/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.dl.calculator;

import cmcm.application.dl.DeltaOperation;
import cmcm.application.dl.DeltaOperationType;
import cmcm.application.dl.DeltaOperationUtilities;
import cmcm.application.dl.DeltaRepresentation;
import cmcm.application.editor.model.graph.Element;
import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.editor.model.graph.layout.DirectedLink;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.layout.UndirectedLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.ModelElement;
import cmcm.application.editor.model.graph.metamodel.mindmap.Branch;
import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import cmcm.application.network.NetworkService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.geometry.planar.Rectangle;

public class DeltaChangeListener
implements PropertyChangeListener {
    private NetworkService networkService;
    private ArrayList<Element> excludedElements = new ArrayList();

    public DeltaChangeListener(GraphModel gm) {
        gm.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.changeShouldBeIgnored(evt)) {
            System.out.println("DCL: Element change will be ignored");
            return;
        }
        DeltaOperation delta = new DeltaOperation();
        switch (evt.getPropertyName()) {
            case "elementAdd": {
                LayoutElement newLayoutElem = (LayoutElement)evt.getNewValue();
                newLayoutElem.addPropertyChangeListener(this);
                delta = this.buildCreateDeltaOperationForLayoutElement(newLayoutElem);
                break;
            }
            case "modelAdd": {
                ModelElement newModelElem = (ModelElement)evt.getNewValue();
                newModelElem.addPropertyChangeListener(this);
                delta = this.buildCreateDeltaOperationForModelElement(newModelElem);
                break;
            }
            case "elementRemove": {
                LayoutElement oldLayoutElem = (LayoutElement)evt.getOldValue();
                oldLayoutElem.removePropertyChangeListener(this);
                delta = this.buildDeleteDeltaOperationForLayoutElement(oldLayoutElem);
                break;
            }
            case "modelRemove": {
                ModelElement oldModelElem = (ModelElement)evt.getOldValue();
                oldModelElem.removePropertyChangeListener(this);
                delta = this.buildDeleteDeltaOperationForLayoutElement(oldModelElem);
                break;
            }
            case "VertexGeometrics": {
                Rectangle geom = (Rectangle)evt.getNewValue();
                delta = this.buildMultiAttributeChangeDeltaOperation(evt, "Vertex", DeltaOperationUtilities.createAttributeList("X " + geom.getX(), "Y " + geom.getY(), "Height " + geom.getSize().getHeight(), "Width " + geom.getSize().getWidth()));
                break;
            }
            case "TermTitle": {
                delta = this.buildChangeDeltaOperation(evt, "Term", "Title");
                break;
            }
            case "TermColor": {
                delta = this.buildChangeDeltaOperation(evt, "Term", "Color");
                break;
            }
            case "CrossReferenceName": {
                delta = this.buildChangeDeltaOperation(evt, "CrossReference", "Name");
                break;
            }
            case "CrossReferenceColor": {
                delta = this.buildChangeDeltaOperation(evt, "CrossReference", "Color");
                break;
            }
            case "CrossReferenceBidirectional": {
                delta = this.buildChangeDeltaOperation(evt, "CrossReference", "Bidirectional");
                break;
            }
            default: {
                System.out.println("DCL: Unknown PropertyChange \"" + evt.getPropertyName() + "\" was fired!");
                return;
            }
        }
        if (!this.updateLastUserOfElement(this.getElementOfEvent(evt))) {
            DeltaOperationUtilities.printDeltaOperationToConsole(delta);
            return;
        }
        delta.getAttributes().add("LastUser " + this.networkService.getUser().getName());
        System.out.println("DCL: " + delta.getModelingArtifact() + " - " + DeltaOperationUtilities.serializeToTextualDelta(delta) + "\n");
        DeltaRepresentation dR = DeltaOperationUtilities.deltaOperationsToDeltaRepresentation(delta);
        this.networkService.requestApplyMicroVersion(dR);
    }

    private DeltaOperation buildMultiAttributeChangeDeltaOperation(PropertyChangeEvent evt, String artifact, List<String> attributeAndValueList) {
        return new DeltaOperation(((Element)evt.getSource()).getUuid().toString(), DeltaOperationType.change, artifact, attributeAndValueList);
    }

    private DeltaOperation buildChangeDeltaOperation(PropertyChangeEvent evt, String artifact, String attribute) {
        return new DeltaOperation(((Element)evt.getSource()).getUuid().toString(), DeltaOperationType.change, artifact, DeltaOperationUtilities.createAttributeList(String.valueOf(attribute) + " " + evt.getNewValue()));
    }

    private DeltaOperation buildDeleteDeltaOperationForLayoutElement(Element oldElem) {
        return new DeltaOperation(oldElem.getUuid().toString(), DeltaOperationType.delete, "Element", DeltaOperationUtilities.createAttributeList(new String[0]));
    }

    private DeltaOperation buildCreateDeltaOperationForLayoutElement(LayoutElement elem) {
        DeltaOperation opCreateLayoutElement = new DeltaOperation();
        opCreateLayoutElement.setIdentifier(elem.getUuid().toString());
        opCreateLayoutElement.setOperationType(DeltaOperationType.create);
        if (elem instanceof Vertex) {
            Vertex v = (Vertex)elem;
            opCreateLayoutElement.setModelingArtifact("Vertex");
            opCreateLayoutElement.setAttributes(DeltaOperationUtilities.createAttributeList("Term " + v.getModelElement().getUuid(), "X " + v.getGeometrics().getX(), "Y " + v.getGeometrics().getY(), "Height " + v.getGeometrics().getHeight(), "Width " + v.getGeometrics().getWidth()));
        } else if (elem instanceof UndirectedLink) {
            UndirectedLink l = (UndirectedLink)elem;
            opCreateLayoutElement.setModelingArtifact("Link");
            opCreateLayoutElement.setAttributes(DeltaOperationUtilities.createAttributeList("Branch " + l.getModelElement().getUuid(), "Source " + l.getSource().getUuid(), "Target " + l.getTarget().getUuid()));
        } else if (elem instanceof DirectedLink) {
            DirectedLink d = (DirectedLink)elem;
            opCreateLayoutElement.setModelingArtifact("DirectedLink");
            opCreateLayoutElement.setAttributes(DeltaOperationUtilities.createAttributeList("CrossReference " + d.getModelElement().getUuid(), "Source " + d.getSource().getUuid(), "Target " + d.getTarget().getUuid()));
        }
        return opCreateLayoutElement;
    }

    private DeltaOperation buildCreateDeltaOperationForModelElement(ModelElement elem) {
        DeltaOperation opCreateModelElement = new DeltaOperation();
        opCreateModelElement.setIdentifier(elem.getUuid().toString());
        opCreateModelElement.setOperationType(DeltaOperationType.create);
        if (elem instanceof Term) {
            if (elem instanceof Branch) {
                Branch b = (Branch)elem;
                opCreateModelElement.setModelingArtifact("Branch");
                opCreateModelElement.setAttributes(DeltaOperationUtilities.createAttributeList("Title " + b.getTitle(), "Color " + b.getColor()));
            } else if (elem instanceof Root) {
                Root r = (Root)elem;
                opCreateModelElement.setModelingArtifact("Root");
                opCreateModelElement.setAttributes(DeltaOperationUtilities.createAttributeList("Title " + r.getTitle(), "Color " + r.getColor()));
            }
        } else if (elem instanceof CrossReference) {
            CrossReference c = (CrossReference)elem;
            opCreateModelElement.setModelingArtifact("CrossReference");
            opCreateModelElement.setAttributes(DeltaOperationUtilities.createAttributeList("Name " + c.getName(), "Color " + c.getColor(), "Bidirectional " + c.isBidirectional()));
        }
        return opCreateModelElement;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    private boolean updateLastUserOfElement(Element elem) {
        if (this.networkService != null) {
            elem.setLastUser(this.networkService.getUser().getName());
            return true;
        }
        return false;
    }

    private boolean changeShouldBeIgnored(PropertyChangeEvent evt) {
        return this.excludedElements.contains(this.getElementOfEvent(evt));
    }

    private Element getElementOfEvent(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("elementAdd") || evt.getPropertyName().equals("modelAdd")) {
            return (Element)evt.getNewValue();
        }
        if (evt.getPropertyName().equals("elementRemove") || evt.getPropertyName().equals("modelRemove")) {
            return (Element)evt.getOldValue();
        }
        return (Element)evt.getSource();
    }

    public ArrayList<Element> getExcludedElements() {
        return this.excludedElements;
    }
}

