/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.graph.mindmap;

import cmcm.application.editor.controller.graph.GraphModelPart;
import cmcm.application.editor.controller.graph.mindmap.MindmapDirectedLinkPart;
import cmcm.application.editor.controller.graph.mindmap.MindmapTermPart;
import cmcm.application.editor.controller.graph.mindmap.MindmapUndirectedLinkPart;
import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.DirectedLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;

public class MindmapPartsFactory
implements IContentPartFactory {
    @Inject
    private Injector injector;

    public IContentPart<? extends Node> createContentPart(Object content, Map<Object, Object> contextMap) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        if (content instanceof GraphModel) {
            return (IContentPart)this.injector.getInstance(GraphModelPart.class);
        }
        if (content instanceof Vertex) {
            return (IContentPart)this.injector.getInstance(MindmapTermPart.class);
        }
        if (content instanceof AbstractLink) {
            if (content instanceof DirectedLink) {
                return (IContentPart)this.injector.getInstance(MindmapDirectedLinkPart.class);
            }
            return (IContentPart)this.injector.getInstance(MindmapUndirectedLinkPart.class);
        }
        throw new IllegalArgumentException("Content class: " + content.getClass() + " needs to extend AbstractGraphElement");
    }
}

