/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.operations.mindmap;

import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import javafx.scene.paint.Color;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class SetCrossReferenceColorOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final CrossReference cr;
    private final Color oldColor;
    private final Color newColor;

    public SetCrossReferenceColorOperation(CrossReference cr, Color newColor) {
        super("Change color");
        this.cr = cr;
        this.oldColor = cr.getColor();
        this.newColor = newColor;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.newColor.equals((Object)this.oldColor);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.cr.setColor(this.newColor);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.cr.getColor().equals((Object)this.oldColor)) {
            this.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.cr.getColor().equals((Object)this.newColor)) {
            this.cr.setColor(this.oldColor);
        }
        return Status.OK_STATUS;
    }
}

