/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.operations.mindmap;

import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import javafx.scene.paint.Color;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class SetTermColorOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final Term term;
    private final Color oldColor;
    private final Color newColor;

    public SetTermColorOperation(Term term, Color newColor) {
        super("Change color");
        this.term = term;
        this.oldColor = term.getColor();
        this.newColor = newColor;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.newColor.equals((Object)this.oldColor);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.term.setColor(this.newColor);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.term.getColor().equals((Object)this.oldColor)) {
            this.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.term.getColor().equals((Object)this.newColor)) {
            this.term.setColor(this.oldColor);
        }
        return Status.OK_STATUS;
    }
}

