/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.model.graph.layout;

import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.layout.Vertex;

public abstract class AbstractLink
extends LayoutElement {
    private static final long serialVersionUID = -8277951147824637402L;
    public static final String PROP_SOURCE = "LinkSource";
    public static final String PROP_TARGET = "LinkTarget";
    protected Vertex source;
    protected Vertex target;
    protected boolean connected;

    public Vertex getSource() {
        return this.source;
    }

    public void setSource(Vertex source) {
        this.source = source;
        this.pcs.firePropertyChange(PROP_SOURCE, this.source, this.source);
    }

    public Vertex getTarget() {
        return this.target;
    }

    public void setTarget(Vertex target) {
        this.target = target;
        this.target = target;
        this.pcs.firePropertyChange(PROP_TARGET, this.target, this.target);
    }

    public void connect(Vertex source, Vertex target) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Vertices dont exist");
        }
        if (source == target) {
            throw new IllegalArgumentException("Vertices cant be connected with themselves");
        }
        if (source.isConnectedWith(target)) {
            throw new IllegalArgumentException("Vertices are already connected!");
        }
        this.disconnect();
        this.setSource(source);
        this.setTarget(target);
        this.source.addOutgoingLink(this);
        this.target.addIncomingLink(this);
        this.connected = true;
    }

    public void disconnect() {
        if (this.connected) {
            this.source.removeOutgoingLink(this);
            this.target.removeIncomingLink(this);
            this.connected = false;
        }
    }
}

