/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.view.graph.mindmap;

import cmcm.application.editor.view.graph.AbstractLinkVisual;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import org.eclipse.gef.fx.nodes.GeometryNode;

public class CrossReferenceVisual
extends AbstractLinkVisual {
    private Text name = new Text();

    public CrossReferenceVisual() {
        Node n = this.getCurve();
        if (n instanceof GeometryNode) {
            ((GeometryNode)n).setStrokeWidth(3.0);
            ((GeometryNode)n).getStrokeDashArray().addAll((Object[])new Double[]{2.0});
            ((GeometryNode)n).setStroke((Paint)Color.ALICEBLUE);
        }
        ArrowHead endDecoration = new ArrowHead();
        endDecoration.setFill((Paint)Color.BLACK);
        this.name.setUnderline(true);
        this.setEndDecoration((Node)endDecoration);
    }

    @Override
    public void setColor(Color color) {
        Node n = this.getCurve();
        if (n instanceof GeometryNode) {
            ((GeometryNode)n).setStroke((Paint)color);
            this.updateDecorationColor();
        }
    }

    public void setName(String text) {
        ArrowHead shape;
        if (!text.isEmpty()) {
            String annotation = "\t" + text;
            this.name.setText(annotation);
            shape = Shape.union((Shape)new ArrowHead(), (Shape)this.name);
        } else {
            shape = new ArrowHead();
        }
        this.setEndDecoration((Node)shape);
        this.updateDecorationColor();
    }

    public void setBidirection(Boolean bidirectional) {
        if (bidirectional.booleanValue()) {
            ArrowHead startDecoration = new ArrowHead();
            startDecoration.setFill((Paint)Color.BLACK);
            this.setStartDecoration((Node)startDecoration);
            this.updateDecorationColor();
        } else {
            this.setStartDecoration(null);
        }
    }

    public void updateDecorationColor() {
        Node n = this.getCurve();
        if (n instanceof GeometryNode) {
            Paint p = ((GeometryNode)n).getStroke();
            Node endD = this.getEndDecoration();
            Node startD = this.getStartDecoration();
            if (endD != null) {
                ((Shape)endD).setFill(p);
            }
            if (startD != null) {
                ((Shape)startD).setFill(p);
            }
        }
    }

    public static class ArrowHead
    extends Polygon {
        public ArrowHead() {
            super(new double[]{0.0, 0.0, 10.0, 7.0, 10.0, -7.0});
        }
    }
}

