/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.gui.editor;

import cmcm.application.editor.view.graph.mindmap.BranchTermVisual;
import cmcm.application.gui.CmcmView;
import java.beans.PropertyChangeEvent;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.VBox;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;

public class EditorView
extends CmcmView {
    private static final double MIN_WIDTH = 800.0;
    private static final double MIN_HEIGHT = 600.0;
    private ToolBar toolBar;
    private Button undoButton;
    private Button redoButton;
    private Button loginButton;
    private Button registerButton;
    private Button modelListButton;
    private Button saveButton;
    private ToggleButton gridToggleButton;
    private Button exportAsPNGButton;
    private Button testButton;
    private VBox palette;
    private ToggleGroup paletteToggleGroup;
    private ToggleButton createVertexToggleButton;
    private ToggleButton createBranchToggleButton;
    private ToggleButton createCrossReferenceToggleButton;

    public EditorView(InfiniteCanvas canvas) {
        this.setCenter((Node)canvas);
    }

    @Override
    protected void createLayout() {
        this.toolBar = this.createToolBar();
        this.palette = this.createPalette();
        this.setTop((Node)this.toolBar);
        this.setRight((Node)this.palette);
    }

    @Override
    protected double getMinX() {
        return 800.0;
    }

    @Override
    protected double getMinY() {
        return 600.0;
    }

    private ToolBar createToolBar() {
        return new ToolBar(new Node[]{this.getUndoButton(), this.getRedoButton(), new Separator(), this.getRegisterButton(), this.getLoginButton(), new Separator(), this.getModelListButton(), this.getSaveButton(), new Separator(), this.getGridButton(), this.getExportAsPNGButton()});
    }

    private Button getUndoButton() {
        this.undoButton = new Button("undo");
        this.undoButton.setDisable(true);
        return this.undoButton;
    }

    private Button getRedoButton() {
        this.redoButton = new Button("redo");
        this.redoButton.setDisable(true);
        return this.redoButton;
    }

    private Node getRegisterButton() {
        this.registerButton = new Button("Register");
        return this.registerButton;
    }

    private Node getLoginButton() {
        this.loginButton = new Button("Login");
        return this.loginButton;
    }

    private Node getModelListButton() {
        this.modelListButton = new Button("Open Model");
        this.modelListButton.setDisable(true);
        return this.modelListButton;
    }

    private Node getSaveButton() {
        this.saveButton = new Button("Save");
        this.saveButton.setDisable(true);
        return this.saveButton;
    }

    private Node getGridButton() {
        this.gridToggleButton = new ToggleButton("Grid");
        this.gridToggleButton.setSelected(true);
        return this.gridToggleButton;
    }

    private Node getExportAsPNGButton() {
        this.exportAsPNGButton = new Button("Export as PNG");
        return this.exportAsPNGButton;
    }

    private VBox createPalette() {
        VBox palette = new VBox();
        BranchTermVisual graphic = new BranchTermVisual();
        graphic.setTitle("Term");
        this.paletteToggleGroup = new ToggleGroup();
        this.createVertexToggleButton = new ToggleButton("", (Node)graphic);
        this.createVertexToggleButton.setToggleGroup(this.paletteToggleGroup);
        this.createBranchToggleButton = new ToggleButton("Branch");
        this.createBranchToggleButton.setToggleGroup(this.paletteToggleGroup);
        this.createBranchToggleButton.setMaxWidth(Double.MAX_VALUE);
        this.createBranchToggleButton.setMinHeight(42.0);
        this.createCrossReferenceToggleButton = new ToggleButton("Cross Reference");
        this.createCrossReferenceToggleButton.setToggleGroup(this.paletteToggleGroup);
        this.createCrossReferenceToggleButton.setMaxWidth(Double.MAX_VALUE);
        this.createCrossReferenceToggleButton.setMinHeight(42.0);
        palette.setSpacing(25.0);
        palette.setPadding(new Insets(25.0, 0.0, 0.0, 0.0));
        palette.getChildren().addAll((Object[])new Node[]{this.createBranchToggleButton, this.createCrossReferenceToggleButton});
        return palette;
    }

    public double getPaletteWidth() {
        return this.palette.getWidth();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property;
        switch (property = evt.getPropertyName()) {
            case "loggedIn": {
                this.loginButton.setDisable(((Boolean)evt.getNewValue()).booleanValue());
                this.modelListButton.setDisable((Boolean)evt.getNewValue() == false);
                break;
            }
            case "modelOpen": {
                this.saveButton.setDisable((Boolean)evt.getNewValue() == false);
                break;
            }
            default: {
                System.out.println("EV: unknown PropertyChangeEvent recieved - " + evt.toString());
            }
        }
    }

    public ToggleGroup getPaletteToggleGroup() {
        return this.paletteToggleGroup;
    }

    public Node getUndoNode() {
        return this.undoButton;
    }

    public Node getRedoNode() {
        return this.redoButton;
    }

    public Node getLoginNode() {
        return this.loginButton;
    }

    public Node getRegisterNode() {
        return this.loginButton;
    }

    public Node getModelListNode() {
        return this.modelListButton;
    }

    public Node getFunctionalityDisplay() {
        return this.toolBar;
    }

    public void setUndoFunctionality(EventHandler<ActionEvent> value) {
        this.undoButton.setOnAction(value);
    }

    public void setRedoFunctionality(EventHandler<ActionEvent> value) {
        this.redoButton.setOnAction(value);
    }

    public void setLoginFunctionality(EventHandler<ActionEvent> value) {
        this.loginButton.setOnAction(value);
    }

    public void setRegisterFunctionality(EventHandler<ActionEvent> value) {
        this.registerButton.setOnAction(value);
    }

    public void setModelListFunctionality(EventHandler<ActionEvent> value) {
        this.modelListButton.setOnAction(value);
    }

    public void setSaveFunctionality(EventHandler<ActionEvent> value) {
        this.saveButton.setOnAction(value);
    }

    public void setGridBehaviour(ChangeListener<? super Boolean> value) {
        this.gridToggleButton.selectedProperty().addListener(value);
    }

    public void setExportAsPNGFunctionality(EventHandler<ActionEvent> value) {
        this.exportAsPNGButton.setOnAction(value);
    }

    public void setTestFunctionality(EventHandler<ActionEvent> value) {
        this.testButton.setOnAction(value);
    }

    public void setCreateVertexBehaviour(ChangeListener<? super Boolean> value) {
        this.createVertexToggleButton.selectedProperty().addListener(value);
    }

    public void setCreateBranchBehaviour(ChangeListener<? super Boolean> value) {
        this.createBranchToggleButton.selectedProperty().addListener(value);
    }

    public void setCreateCrossReferenceBehaviour(ChangeListener<? super Boolean> value) {
        this.createCrossReferenceToggleButton.selectedProperty().addListener(value);
    }
}

