/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.dl.applier;

import cmcm.application.dl.DeltaOperation;
import cmcm.application.dl.DeltaOperationUtilities;
import cmcm.application.dl.DeltaRepresentation;
import cmcm.application.editor.model.graph.Element;
import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.DirectedLink;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.layout.UndirectedLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.ModelElement;
import cmcm.application.editor.model.graph.metamodel.mindmap.Branch;
import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import java.util.ArrayList;
import java.util.UUID;
import javafx.scene.paint.Color;

public class DeltaApplier {
    private DeltaRepresentation deltaRepresentation;
    private GraphModel gm;
    private ArrayList<Element> newElements = new ArrayList();
    private ArrayList<Element> deletedElements = new ArrayList();
    private static ArrayList<DeltaOperation> nonModelBasedGraphElements = new ArrayList();
    private boolean updateMode;
    private ArrayList<Element> excludedElements;

    public DeltaApplier(GraphModel gm) {
        this.gm = gm;
    }

    public synchronized void applyDelta(DeltaRepresentation deltaRepr) {
        this.deltaRepresentation = deltaRepr;
        for (String operationAsString : this.deltaRepresentation.getOperationList()) {
            if (!DeltaOperationUtilities.isValidDeltaOperationType(operationAsString).booleanValue()) continue;
            DeltaOperation deltaOp = DeltaOperationUtilities.convertToDeltaOperation(operationAsString);
            System.out.print("\tDA: ");
            DeltaOperationUtilities.printDeltaOperationToConsole(deltaOp);
            this.updateLastUserOfExistingElement(deltaOp);
            this.applyOperation(deltaOp);
        }
    }

    private void applyOperation(DeltaOperation deltaOp) {
        switch (deltaOp.getOperationType()) {
            case create: {
                this.applyCreate(deltaOp);
                break;
            }
            case delete: {
                this.applyDelete(deltaOp);
                break;
            }
            case change: {
                this.applyChange(deltaOp);
            }
        }
    }

    private void applyCreate(DeltaOperation deltaOp) {
        String elemType = deltaOp.getModelingArtifact();
        Element newElem = null;
        boolean isGraphElement = true;
        switch (elemType) {
            case "Vertex": {
                try {
                    newElem = this.createVertexByDeltaOperation(deltaOp);
                    break;
                }
                catch (Exception e) {
                    System.out.println("\t\tDA: Creation failed, Exception: " + e.getMessage());
                    return;
                }
            }
            case "Link": {
                try {
                    newElem = this.createLinkByDeltaOperation(deltaOp);
                    break;
                }
                catch (Exception e) {
                    System.out.println("\t\tDA: Creation failed, Exception: " + e.getMessage());
                    return;
                }
            }
            case "DirectedLink": {
                try {
                    newElem = this.createDirectedLinkByDeltaOperation(deltaOp);
                    break;
                }
                catch (Exception e) {
                    System.out.println("\t\tDA: Creation failed, Exception: " + e.getMessage());
                    return;
                }
            }
            case "Branch": {
                newElem = this.createBranchByDeltaOperation(deltaOp);
                isGraphElement = false;
                break;
            }
            case "Root": {
                newElem = this.createRootByDeltaOperation(deltaOp);
                isGraphElement = false;
                break;
            }
            case "CrossReference": {
                newElem = this.createCrossReferenceByDeltaOperation(deltaOp);
                isGraphElement = false;
                break;
            }
            default: {
                System.out.println("\t\tDA: applyCreate() failed, unknown Element Type");
                return;
            }
        }
        newElem.setUuid(UUID.fromString(deltaOp.getIdentifier()));
        newElem.setLastUser(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "LastUser"));
        System.out.println("\t\tDA: Creation successful, adding to Graph");
        if (isGraphElement) {
            this.gm.addChildElement((LayoutElement)newElem);
        } else {
            this.gm.addModelElement((ModelElement)newElem);
            this.checkIfNonModelBasedGraphElementsAreBasedOnModelElement(newElem);
        }
        this.newElements.add(newElem);
        if (this.updateMode) {
            this.excludedElements.remove(newElem);
        }
    }

    private Vertex createVertexByDeltaOperation(DeltaOperation deltaOp) throws Exception {
        String idOfTerm = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Term");
        Element elem = null;
        if (!idOfTerm.isEmpty()) {
            elem = this.gm.getElementByID(UUID.fromString(idOfTerm));
        }
        if (elem != null) {
            Vertex vertex = new Vertex((Term)elem);
            if (this.updateMode) {
                this.excludedElements.add(vertex);
            }
            vertex.setX(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "X")));
            vertex.setY(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Y")));
            vertex.setHeight(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Height")));
            vertex.setWidth(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Width")));
            return vertex;
        }
        nonModelBasedGraphElements.add(deltaOp);
        throw new RuntimeException("LayoutElement needs to be based on a ModelElement");
    }

    private Element createLinkByDeltaOperation(DeltaOperation deltaOp) throws Exception {
        String idOfBranch = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Branch");
        String idOfSource = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Source");
        String idOfTarget = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Target");
        Vertex source = null;
        Vertex target = null;
        Branch branch = null;
        if (!(idOfBranch.isEmpty() || idOfSource.isEmpty() || idOfTarget.isEmpty())) {
            branch = (Branch)this.gm.getElementByID(UUID.fromString(idOfBranch));
            source = (Vertex)this.gm.getElementByID(UUID.fromString(idOfSource));
            target = (Vertex)this.gm.getElementByID(UUID.fromString(idOfTarget));
        }
        if (branch != null) {
            if (source == null || target == null) {
                throw new RuntimeException("Link depends on Elements that don't exist");
            }
            UndirectedLink link = new UndirectedLink(branch);
            if (this.updateMode) {
                this.excludedElements.add(link);
            }
            link.connect(source, target);
            return link;
        }
        nonModelBasedGraphElements.add(deltaOp);
        throw new RuntimeException("LayoutElement needs to be based on a ModelElement");
    }

    private Element createDirectedLinkByDeltaOperation(DeltaOperation deltaOp) throws Exception {
        String idOfCrossRef = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "CrossReference");
        String idOfSource = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Source");
        String idOfTarget = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Target");
        Vertex source = null;
        Vertex target = null;
        CrossReference crossRef = null;
        if (!(idOfCrossRef.isEmpty() || idOfSource.isEmpty() || idOfTarget.isEmpty())) {
            crossRef = (CrossReference)this.gm.getElementByID(UUID.fromString(idOfCrossRef));
            source = (Vertex)this.gm.getElementByID(UUID.fromString(idOfSource));
            target = (Vertex)this.gm.getElementByID(UUID.fromString(idOfTarget));
        }
        if (crossRef != null) {
            if (source == null || target == null) {
                throw new RuntimeException("DirectedLink depends on Elements that don't exist");
            }
            DirectedLink directedLink = new DirectedLink(crossRef);
            if (this.updateMode) {
                this.excludedElements.add(directedLink);
            }
            directedLink.connect(source, target);
            return directedLink;
        }
        nonModelBasedGraphElements.add(deltaOp);
        throw new RuntimeException("LayoutElement needs to be based on a ModelElement");
    }

    private Branch createBranchByDeltaOperation(DeltaOperation deltaOp) {
        Branch branch = new Branch(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Title"));
        if (this.updateMode) {
            this.excludedElements.add(branch);
        }
        branch.setColor(Color.valueOf((String)DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Color")));
        return branch;
    }

    private Root createRootByDeltaOperation(DeltaOperation deltaOp) {
        Root root = new Root(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Title"));
        root.setColor(Color.valueOf((String)DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Color")));
        return root;
    }

    private CrossReference createCrossReferenceByDeltaOperation(DeltaOperation deltaOp) {
        CrossReference crossRef = new CrossReference();
        crossRef.setName(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Name"));
        crossRef.setColor(Color.valueOf((String)DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Color")));
        crossRef.setBidirectional(Boolean.getBoolean(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Bidirectional")));
        return crossRef;
    }

    private void applyDelete(DeltaOperation deltaOp) {
        Element elem = this.gm.getElementByID(UUID.fromString(deltaOp.getIdentifier()));
        if (elem != null) {
            if (this.updateMode) {
                this.excludedElements.add(elem);
            }
            if (elem instanceof AbstractLink) {
                ((AbstractLink)elem).disconnect();
            }
            this.deletedElements.add(elem);
            this.gm.removeElement(elem);
            if (this.updateMode) {
                this.excludedElements.remove(elem);
            }
        }
    }

    private void applyChange(DeltaOperation deltaOp) {
        Element elem = this.gm.getElementByID(UUID.fromString(deltaOp.getIdentifier()));
        if (elem != null) {
            if (this.updateMode) {
                this.excludedElements.add(elem);
            }
            String attribute = deltaOp.getAttribute();
            if (elem instanceof Vertex) {
                Vertex vertex = (Vertex)elem;
                for (String att : deltaOp.getAttributes()) {
                    if (att.contains("X")) {
                        vertex.setX(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(att, "X")));
                    }
                    if (att.contains("Y")) {
                        vertex.setY(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(att, "Y")));
                    }
                    if (att.contains("Height")) {
                        vertex.setHeight(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(att, "Height")));
                    }
                    if (!att.contains("Width")) continue;
                    vertex.setWidth(Double.parseDouble(DeltaOperationUtilities.getAttributeValue(att, "Width")));
                }
            } else if (elem instanceof Term) {
                Term term = (Term)elem;
                if (attribute.contains("Title")) {
                    term.setTitle(DeltaOperationUtilities.getAttributeValue(attribute, "Title"));
                } else if (attribute.contains("Color")) {
                    term.setColor(Color.valueOf((String)DeltaOperationUtilities.getAttributeValue(attribute, "Color")));
                }
            } else if (elem instanceof CrossReference) {
                CrossReference crossRef = (CrossReference)elem;
                if (attribute.contains("Name")) {
                    crossRef.setName(DeltaOperationUtilities.getAttributeValue(attribute, "Name"));
                } else if (attribute.contains("Color")) {
                    crossRef.setColor(Color.valueOf((String)DeltaOperationUtilities.getAttributeValue(attribute, "Color")));
                } else if (attribute.contains("Bidirectional")) {
                    crossRef.setBidirectional(Boolean.parseBoolean(DeltaOperationUtilities.getAttributeValue(attribute, "Bidirectional")));
                }
            } else {
                System.out.println("\t\tDA: applyChange() failed. Couldn't identify the Type");
            }
            if (this.updateMode) {
                this.excludedElements.remove(elem);
            }
        } else {
            System.out.println("\t\tDA: applyChange() failed. Couldn't find a corresponding Element");
        }
    }

    private boolean updateLastUserOfExistingElement(DeltaOperation deltaOp) {
        Element elem;
        String lastUserValue = DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "LastUser");
        if (!lastUserValue.isEmpty() && (elem = this.gm.getElementByID(UUID.fromString(deltaOp.getIdentifier()))) != null && !elem.getLastUser().equals(lastUserValue)) {
            elem.setLastUser(lastUserValue);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkIfNonModelBasedGraphElementsAreBasedOnModelElement(Element newModelElem) {
        block10: for (DeltaOperation deltaOp : nonModelBasedGraphElements) {
            switch (deltaOp.getModelingArtifact()) {
                case "Vertex": {
                    if (newModelElem.getUuid().equals(UUID.fromString(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Term")))) break;
                    continue block10;
                }
                case "Link": {
                    if (newModelElem.getUuid().equals(UUID.fromString(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Branch")))) break;
                    continue block10;
                }
                case "DirectedLink": {
                    if (!newModelElem.getUuid().equals(UUID.fromString(DeltaOperationUtilities.getAttributeValue(deltaOp.getAttributes(), "Term")))) continue block10;
                }
            }
            this.deltaRepresentation.getOperationList().add(DeltaOperationUtilities.serializeToTextualDelta(deltaOp));
        }
    }

    public void startUpdateMode(ArrayList<Element> excludedElements) {
        this.excludedElements = excludedElements;
        this.updateMode = true;
    }

    public void stopUpdateMode() {
        this.excludedElements = null;
        this.updateMode = false;
    }

    public ArrayList<Element> getAllCreatedElements() {
        return this.newElements;
    }

    public ArrayList<Element> getAllDeletedElements() {
        return this.deletedElements;
    }
}

