/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.graph;

import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.ModelElement;
import cmcm.application.editor.view.graph.AbstractVertexVisual;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.IResizableContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;

public abstract class AbstractVertexPart<T extends AbstractVertexVisual>
extends AbstractContentPart<T>
implements ITransformableContentPart<T>,
IResizableContentPart<T>,
PropertyChangeListener {
    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    public Affine getContentTransform() {
        Rectangle geometrics = this.getContent().getGeometrics();
        return new Affine((Transform)new Translate(geometrics.getX(), geometrics.getY()));
    }

    public void setContentTransform(Affine totalTransform) {
        Rectangle newGeometrics = this.getContent().getGeometrics().getCopy();
        newGeometrics.setX(totalTransform.getTx());
        newGeometrics.setY(totalTransform.getTy());
        this.getContent().setGeometrics(newGeometrics);
    }

    public Dimension getContentSize() {
        return this.getContent().getGeometrics().getSize();
    }

    public void setContentSize(Dimension totalSize) {
        this.getContent().setGeometrics((Rectangle)new Rectangle(this.getContent().getGeometrics()).setSize(totalSize));
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().addPropertyChangeListener(this);
        this.getModel().addPropertyChangeListener(this);
    }

    protected void doDeactivate() {
        this.getContent().removePropertyChangeListener(this);
        this.getModel().removePropertyChangeListener(this);
        super.doDeactivate();
    }

    public Vertex getContent() {
        return (Vertex)super.getContent();
    }

    public abstract ModelElement getModel();
}

