/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.policies.mindmap;

import cmcm.application.editor.controller.graph.GraphModelPart;
import cmcm.application.editor.controller.graph.mindmap.MindmapTermPart;
import cmcm.application.editor.model.ItemCreationModel;
import cmcm.application.editor.model.graph.layout.DirectedLink;
import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import com.google.common.collect.HashMultimap;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.operations.ChangeSelectionOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class CreateNewCrossReferenceOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    public void click(MouseEvent e) {
        MindmapTermPart targetPart;
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ItemCreationModel cModel = (ItemCreationModel)viewer.getAdapter(ItemCreationModel.class);
        if (cModel.getPlacementState() != ItemCreationModel.PlacementState.DIRECTEDLINK) {
            return;
        }
        if (!cModel.hasSource()) {
            cModel.setSource((MindmapTermPart)this.getHost());
            return;
        }
        MindmapTermPart sourcePart = cModel.getSource();
        if (sourcePart == (targetPart = (MindmapTermPart)this.getHost())) {
            return;
        }
        IVisualPart part = (IVisualPart)this.getHost().getRoot().getChildrenUnmodifiable().get(0);
        if (part instanceof GraphModelPart) {
            DirectedLink newLink = new DirectedLink(new CrossReference(sourcePart.getModel().getColor()));
            newLink.connect(sourcePart.getContent(), targetPart.getContent());
            IRootPart root = this.getHost().getRoot();
            CreationPolicy creationPolicy = (CreationPolicy)root.getAdapter((TypeToken)new TypeToken<CreationPolicy>(){});
            this.init((IPolicy)creationPolicy);
            creationPolicy.create((Object)newLink, (IVisualPart)((GraphModelPart)part), HashMultimap.create());
            this.commit((IPolicy)creationPolicy);
            try {
                viewer.getDomain().execute((ITransactionalOperation)new ChangeSelectionOperation(viewer, Collections.singletonList(targetPart)), null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        cModel.setSource(null);
        cModel.setPlacementState(ItemCreationModel.PlacementState.NONE);
    }
}

