/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.model.graph;

import cmcm.application.editor.model.graph.Element;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.metamodel.ModelElement;
import com.google.common.collect.Lists;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.UUID;

public class GraphModel
extends Element {
    private static final long serialVersionUID = 1097102477745219773L;
    private String name;
    private List<LayoutElement> layoutElements = Lists.newArrayList();
    public static final String PROP_LAYOUT_ELEM_ADD = "elementAdd";
    public static final String PROP_LAYOUT_ELEM_REMOVE = "elementRemove";
    private List<ModelElement> modelElements = Lists.newArrayList();
    public static final String PROP_MODEL_ELEM_ADD = "modelAdd";
    public static final String PROP_MODEL_ELEM_REMOVE = "modelRemove";

    public GraphModel() {
        this.setName("GraphModel");
    }

    public GraphModel(String name) {
        this.setName(name);
    }

    public boolean addChildElement(LayoutElement elem) {
        if (elem.getModelElement() == null) {
            return false;
        }
        if (!this.hasElementWithID(elem.getModelElement().getUuid())) {
            this.modelElements.add(elem.getModelElement());
            this.pcs.firePropertyChange(PROP_MODEL_ELEM_ADD, null, elem.getModelElement());
        }
        if (!this.hasElementWithID(elem.getUuid())) {
            this.layoutElements.add(elem);
            this.pcs.firePropertyChange(PROP_LAYOUT_ELEM_ADD, null, elem);
            return true;
        }
        return false;
    }

    public void addChildElement(LayoutElement elem, int idx) {
        if (elem.getModelElement() == null) {
            return;
        }
        if (!this.hasElementWithID(elem.getModelElement().getUuid())) {
            this.modelElements.add(elem.getModelElement());
            this.pcs.firePropertyChange(PROP_MODEL_ELEM_ADD, null, elem.getModelElement());
        }
        this.layoutElements.add(idx, elem);
        this.pcs.firePropertyChange(PROP_LAYOUT_ELEM_ADD, null, elem);
    }

    public void addModelElement(ModelElement elem) {
        if (!this.hasElementWithID(elem.getUuid())) {
            this.modelElements.add(elem);
            this.pcs.firePropertyChange(PROP_MODEL_ELEM_ADD, null, elem);
        }
    }

    public List<LayoutElement> getChildElements() {
        return this.layoutElements;
    }

    public boolean removeChildElement(LayoutElement elem) {
        if (this.layoutElements.remove(elem)) {
            this.modelElements.remove(elem.getModelElement());
            this.pcs.firePropertyChange(PROP_LAYOUT_ELEM_REMOVE, elem, null);
            this.pcs.firePropertyChange(PROP_MODEL_ELEM_REMOVE, elem.getModelElement(), null);
            return true;
        }
        return false;
    }

    public boolean removeModelElement(ModelElement elem) {
        for (LayoutElement gElem : this.layoutElements) {
            if (!gElem.getModelElement().equals(elem)) continue;
            this.removeChildElement(gElem);
        }
        return this.modelElements.remove(elem);
    }

    public boolean removeElement(Element elem) {
        if (this.layoutElements.contains(elem)) {
            return this.removeChildElement((LayoutElement)elem);
        }
        if (this.modelElements.contains(elem)) {
            return this.removeModelElement((ModelElement)elem);
        }
        return false;
    }

    public Element getElementByID(UUID uuid) {
        Element elem = null;
        for (LayoutElement gElem : this.layoutElements) {
            if (gElem.getUuid().compareTo(uuid) != 0) continue;
            elem = gElem;
        }
        for (ModelElement mElem : this.modelElements) {
            if (mElem.getUuid().compareTo(uuid) != 0) continue;
            elem = mElem;
        }
        return elem;
    }

    private boolean hasElementWithID(UUID uuid) {
        return this.getElementByID(uuid) != null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
        for (LayoutElement gElem : this.layoutElements) {
            gElem.addPropertyChangeListener(pcl);
        }
        for (ModelElement mElem : this.modelElements) {
            mElem.addPropertyChangeListener(pcl);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this.layoutElements.isEmpty() && this.modelElements.isEmpty();
    }
}

