/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.model.graph.layout;

import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.gef.geometry.planar.Rectangle;

public class Vertex
extends LayoutElement {
    private static final long serialVersionUID = 4074106157896310003L;
    public static final String PROP_X = "VertexX";
    public static final String PROP_Y = "VertexY";
    public static final String PROP_WIDTH = "VertexWidth";
    public static final String PROP_HEIGHT = "VertexHeight";
    public static final String PROP_GEOMETRICS = "VertexGeometrics";
    public static final String PROP_INCOMING_LINKS = "VertexIncomingLinks";
    public static final String PROP_OUTGOING_LINKS = "VertexOutgoingLinks";
    private Rectangle geometrics = new Rectangle();
    private List<AbstractLink> incomingLinks = Lists.newArrayList();
    private List<AbstractLink> outgoingLinks = Lists.newArrayList();
    private Term term;

    public Vertex(Term term) {
        this.term = term;
    }

    @Override
    public Term getModelElement() {
        return this.term;
    }

    public Rectangle getGeometrics() {
        return this.geometrics.getCopy();
    }

    public void setGeometrics(Rectangle geometrics) {
        Rectangle oldGeometrics = new Rectangle(this.geometrics);
        this.geometrics.setX(geometrics.getX());
        this.geometrics.setY(geometrics.getY());
        this.geometrics.setHeight(geometrics.getSize().getHeight());
        this.geometrics.setWidth(geometrics.getSize().getWidth());
        this.pcs.firePropertyChange(PROP_GEOMETRICS, oldGeometrics, geometrics);
    }

    public void setX(double x) {
        double oldX = this.geometrics.getX();
        if (oldX != x) {
            this.geometrics.setX(x);
            this.pcs.firePropertyChange(PROP_X, oldX, x);
        }
    }

    public void setY(double y) {
        double oldY = this.geometrics.getY();
        if (oldY != y) {
            this.geometrics.setY(y);
            this.pcs.firePropertyChange(PROP_Y, oldY, y);
        }
    }

    public void setHeight(double height) {
        double oldHeight = this.geometrics.getSize().getHeight();
        if (oldHeight != height) {
            this.geometrics.setHeight(height);
            this.pcs.firePropertyChange(PROP_HEIGHT, oldHeight, height);
        }
    }

    public void setWidth(double width) {
        double oldWidth = this.geometrics.getSize().getWidth();
        if (oldWidth != width) {
            this.geometrics.setWidth(width);
            this.pcs.firePropertyChange(PROP_WIDTH, oldWidth, width);
        }
    }

    public List<AbstractLink> getIncomingLinks() {
        return this.incomingLinks;
    }

    public List<AbstractLink> getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public void addIncomingLink(AbstractLink link) {
        this.incomingLinks.add(link);
        this.pcs.firePropertyChange(PROP_INCOMING_LINKS, null, link);
    }

    public void addOutgoingLink(AbstractLink link) {
        this.outgoingLinks.add(link);
        this.pcs.firePropertyChange(PROP_OUTGOING_LINKS, null, link);
    }

    public void removeIncomingLink(AbstractLink link) {
        this.incomingLinks.remove(link);
        this.pcs.firePropertyChange(PROP_INCOMING_LINKS, link, null);
    }

    public void removeOutgoingLink(AbstractLink link) {
        this.outgoingLinks.remove(link);
        this.pcs.firePropertyChange(PROP_OUTGOING_LINKS, link, null);
    }

    public boolean hasOutgoingLinks() {
        return !this.outgoingLinks.isEmpty();
    }

    public boolean isConnectedWith(Vertex otherVertex) {
        for (AbstractLink link : this.outgoingLinks) {
            if (!link.getTarget().equals(otherVertex)) continue;
            return true;
        }
        for (AbstractLink link : this.incomingLinks) {
            if (!link.getSource().equals(otherVertex)) continue;
            return true;
        }
        return false;
    }
}

