/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.view.examples;

import cmcm.application.editor.view.graph.mindmap.BranchLinkVisual;
import cmcm.application.editor.view.graph.mindmap.BranchTermVisual;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import org.eclipse.gef.fx.anchors.ChopBoxStrategy;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.IComputationStrategy;
import org.eclipse.gef.geometry.planar.Point;

public class MindmapVisualExample
extends Application {
    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        Pane root = new Pane();
        BranchTermVisual term = this.createVisual("Test term 1 With a lot of text actually\n test\n test\n test\n test", 250.0, 250.0);
        BranchTermVisual term2 = this.createVisual("Test term 2", 250.0, 500.0);
        BranchLinkVisual link = new BranchLinkVisual();
        link.setStartAnchor((IAnchor)new DynamicAnchor((Node)term, (IComputationStrategy)new ChopBoxStrategy()));
        link.setEndAnchor((IAnchor)new DynamicAnchor((Node)term2, (IComputationStrategy)new ChopBoxStrategy()));
        link.addControlPoint(0, new Point(350.0, 400.0));
        root.getChildren().addAll((Object[])new Node[]{link, term, term2, this.createVisual("outOfSight1", 1000.0, 1000.0), this.createVisual("outOfSight2", -15.0, -15.0), this.createVisual("Test term 3", 500.0, 100.0), this.createVisual("Test term 4", 100.0, 100.0), this.createVisual("Test term 4", 101.0, 101.0), this.createVisual("Test term 4", 102.0, 102.0), this.createVisual("Test term 4", 103.0, 103.0)});
        primaryStage.setScene(new Scene((Parent)root, 800.0, 600.0));
        primaryStage.setTitle("Visual Example");
        primaryStage.sizeToScene();
        primaryStage.show();
    }

    private BranchTermVisual createVisual(String title, double x, double y) {
        BranchTermVisual mtv = new BranchTermVisual();
        mtv.setTitle(title);
        mtv.relocate(x, y);
        return mtv;
    }
}

