/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.gui;

import cmcm.application.gui.authentication.LoginData;
import cmcm.application.gui.authentication.RegisterData;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.util.Pair;

public final class DialogUtilities {
    private DialogUtilities() {
    }

    public static String showDialogAndGetString(String title, String text) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(title);
        dialog.setHeaderText(text);
        Optional result = dialog.showAndWait();
        return result.orElse("");
    }

    public static String showDialogWithContentAndGetString(String title, String text, String content) {
        TextInputDialog dialog = new TextInputDialog();
        dialog.setTitle(title);
        dialog.setHeaderText(text);
        dialog.setContentText(content);
        Optional result = dialog.showAndWait();
        return result.orElse("");
    }

    public static String showDialogWithDefaultValueAndGetString(String title, String text, String defaultValue) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.setTitle(title);
        dialog.setGraphic(null);
        dialog.setHeaderText(text);
        Optional result = dialog.showAndWait();
        String entered = defaultValue;
        if (result.isPresent()) {
            entered = (String)result.get();
        }
        return entered;
    }

    public static void showAlert(String title, String text, Alert.AlertType type) {
        Alert alert = new Alert(type);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(text);
        alert.showAndWait();
    }

    public static void showLoginDialog(Consumer<LoginData> onSuccess) {
        Dialog loginDialog = new Dialog();
        loginDialog.setTitle("CMCM Authentication");
        loginDialog.setHeaderText("Login: ");
        ButtonType loginButtonType = new ButtonType("Login", ButtonBar.ButtonData.OK_DONE);
        loginDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, ButtonType.CANCEL});
        TextField emailField = new TextField();
        PasswordField passwordField = new PasswordField();
        emailField.setPromptText("E-Mail");
        passwordField.setPromptText("Password");
        GridPane grid = new GridPane();
        grid.setHgap(4.0);
        grid.setVgap(4.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label("E-mail:"), 0, 0);
        grid.add((Node)new Label("Password:"), 0, 1);
        grid.add((Node)emailField, 1, 0);
        grid.add((Node)passwordField, 1, 1);
        loginDialog.getDialogPane().lookupButton(loginButtonType).disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !emailField.getText().matches("^(.+)@(.+)$") || passwordField.getText().trim().isEmpty(), (Observable[])new Observable[]{emailField.textProperty(), passwordField.textProperty()}));
        loginDialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> emailField.requestFocus());
        loginDialog.setResultConverter(dialogButton -> {
            if (dialogButton == loginButtonType) {
                return new Pair((Object)emailField.getText(), (Object)passwordField.getText());
            }
            return null;
        });
        Optional result = loginDialog.showAndWait();
        if (!result.isPresent()) {
            return;
        }
        Pair resultAsStrings = (Pair)result.get();
        LoginData data = new LoginData((String)resultAsStrings.getKey(), ((String)resultAsStrings.getValue()).toCharArray());
        onSuccess.accept(data);
    }

    public static void showRegisterDialog(Consumer<RegisterData> onSuccess) {
        Dialog registerDialog = new Dialog();
        registerDialog.setTitle("CMCM Authentication");
        registerDialog.setHeaderText("Register: ");
        ButtonType registerButtonType = new ButtonType("Register", ButtonBar.ButtonData.OK_DONE);
        registerDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{registerButtonType, ButtonType.CANCEL});
        TextField userField = new TextField();
        TextField emailField = new TextField();
        PasswordField passwordField = new PasswordField();
        userField.setPromptText("Username");
        emailField.setPromptText("E-Mail");
        passwordField.setPromptText("Password");
        GridPane grid = new GridPane();
        grid.setHgap(4.0);
        grid.setVgap(4.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label("Username"), 0, 0);
        grid.add((Node)new Label("E-mail:"), 0, 1);
        grid.add((Node)new Label("Password:"), 0, 2);
        grid.add((Node)userField, 1, 0);
        grid.add((Node)emailField, 1, 1);
        grid.add((Node)passwordField, 1, 2);
        registerDialog.getDialogPane().lookupButton(registerButtonType).disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> userField.getText().trim().isEmpty() || !emailField.getText().matches("^(.+)@(.+)$") || passwordField.getText().trim().isEmpty(), (Observable[])new Observable[]{userField.textProperty(), emailField.textProperty(), passwordField.textProperty()}));
        registerDialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> userField.requestFocus());
        registerDialog.setResultConverter(dialogButton -> {
            if (dialogButton == registerButtonType) {
                return new Pair((Object)new Pair((Object)userField.getText(), (Object)emailField.getText()), (Object)passwordField.getText());
            }
            return null;
        });
        Optional result = registerDialog.showAndWait();
        if (!result.isPresent()) {
            return;
        }
        Pair resultAsStrings = (Pair)result.get();
        RegisterData data = new RegisterData((String)((Pair)resultAsStrings.getKey()).getKey(), (String)((Pair)resultAsStrings.getKey()).getValue(), ((String)resultAsStrings.getValue()).toCharArray());
        onSuccess.accept(data);
    }
}

