/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.network;

import cmcm.application.dl.DeltaRepresentation;
import cmcm.application.dl.applier.DeltaApplier;
import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.gui.editor.EditorController;
import cmcm.application.network.NetworkManager;
import cmcm.application.network.shared.messages.dto.Repository;
import cmcm.application.network.shared.messages.dto.User;
import cmcm.application.network.shared.messages.repository.request.ApplyMicroVersionMessage;
import cmcm.application.network.shared.messages.repository.request.CreateMacroVersionMessage;
import cmcm.application.network.shared.messages.repository.request.CreateRepositoryMessage;
import cmcm.application.network.shared.messages.repository.request.DeleteRepositoryMessage;
import cmcm.application.network.shared.messages.repository.request.GetRepositoryMessage;
import cmcm.application.network.shared.messages.user.request.CreateUserMessage;
import cmcm.application.network.shared.messages.user.request.LoginMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.MqttException;

public class NetworkService {
    private NetworkManager networkManager;
    private EditorController editorController;
    private User user;
    private Repository repository;

    public NetworkService(String serverURI) {
        this.connectToServer(serverURI);
    }

    private void connectToServer(String serverURI) {
        this.networkManager = new NetworkManager(serverURI, this);
    }

    public void requestLogin(String email, char[] password) {
        LoginMessage loginMsg = new LoginMessage();
        loginMsg.setEmail(email);
        loginMsg.setPassword(String.valueOf(password));
        System.out.println("NS: Sending LoginMessage..");
        this.networkManager.sendMessage(loginMsg);
    }

    public void requestRegister(String name, String email, char[] password) {
        CreateUserMessage createUserMsg = new CreateUserMessage();
        createUserMsg.setName(name);
        createUserMsg.setEmail(email);
        createUserMsg.setPassword(String.valueOf(password));
        createUserMsg.setGroup(false);
        System.out.println("NS: Sending CreateUserMessage..");
        this.networkManager.sendMessage(createUserMsg);
    }

    public void requestModelList() {
        GetRepositoryMessage reposMsg = new GetRepositoryMessage();
        System.out.println("NS: Sending GetRepositoryMessage.. (Requests Model List)");
        this.networkManager.sendMessage(reposMsg);
    }

    public void requestCreateNewModel(String name, String description) {
        CreateRepositoryMessage createRepoMsg = new CreateRepositoryMessage();
        createRepoMsg.setName(name);
        System.out.println("NS: Sending CreateRepositoryMessage..");
        this.networkManager.sendMessage(createRepoMsg);
    }

    public void requestDeleteModel() {
        DeleteRepositoryMessage deleteRepoMsg = new DeleteRepositoryMessage();
        deleteRepoMsg.setId(this.repository.getId());
        System.out.println("NS: Sending DeleteRepositoryMessage..");
        this.networkManager.sendMessage(deleteRepoMsg);
    }

    public void requestDeleteModel(Repository repo) {
        DeleteRepositoryMessage deleteRepoMsg = new DeleteRepositoryMessage();
        deleteRepoMsg.setId(repo.getId());
        System.out.println("NS: Sending DeleteRepositoryMessage..");
        this.networkManager.sendMessage(deleteRepoMsg);
    }

    public void requestActiveDeltaOfModel(Repository repo) {
        GetRepositoryMessage repoMsg = new GetRepositoryMessage();
        repoMsg.setId(repo.getId());
        System.out.println("NS: Sending GetRepositoryMessage.. (Requests specific Model)");
        this.networkManager.sendMessage(repoMsg);
    }

    public void requestVersionOfModel(Repository repo, int version) {
        GetRepositoryMessage repoVersionMsg = new GetRepositoryMessage();
        repoVersionMsg.setId(repo.getId());
        repoVersionMsg.setVersion(version);
        System.out.println("NS: Sending GetRepositoryMessage.. (Requests Version of specific Model)");
        this.networkManager.sendMessage(repoVersionMsg);
    }

    public void requestSaveModel() {
        GetRepositoryMessage repoMsg = new GetRepositoryMessage();
        repoMsg.setId(this.repository.getId());
        this.networkManager.setVersionSave(true);
        System.out.println("NS: Sending GetRepositoryMessage.. (To get Current Delta and save as Version)");
        this.networkManager.sendMessage(repoMsg);
    }

    public void requestApplyMicroVersion(DeltaRepresentation delta) {
        if (delta.getOperationList() == null) {
            System.out.println("NS: MicroVersion is empty");
            return;
        }
        ApplyMicroVersionMessage applyMicroMsg = new ApplyMicroVersionMessage();
        applyMicroMsg.microVersion = delta.getOperationList();
        applyMicroMsg.id = this.repository.getId();
        System.out.println("NS: Sending ApplyMicroVersionMessage..");
        this.networkManager.sendMessage(applyMicroMsg);
    }

    public void handleLogin(User user) {
        this.user = user;
        this.editorController.loginSuccessful();
    }

    public void handleRegister() {
        this.editorController.registerSuccessful();
    }

    public void handleModelList(List<Repository> repos) {
        this.editorController.createProjectOverview(repos);
    }

    public void handleApplyMacroVersion(DeltaRepresentation deltaRepr) {
        GraphModel gm = new GraphModel();
        DeltaApplier da = new DeltaApplier(gm);
        System.out.println("NS: DeltaApplier active for MacroVersion");
        da.applyDelta(deltaRepr);
        this.editorController.loadModel(gm);
    }

    public void handleApplyMicroVersion(DeltaRepresentation deltaRepr) {
        this.editorController.updateModel(deltaRepr);
    }

    public void handleModelForSaving(Repository repo, String versionComment) {
        CreateMacroVersionMessage createMacroMsg = new CreateMacroVersionMessage();
        createMacroMsg.setId(repo.getId());
        createMacroMsg.setMessage(versionComment);
        createMacroMsg.setMacroVersion(repo.getModel().getOperationList());
        System.out.println("NS: Sending CreateMacroVersionMessage..");
        this.networkManager.sendMessage(createMacroMsg);
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setEditorController(EditorController eController) {
        this.editorController = eController;
    }

    public void disconnectFromServer() throws MqttException {
        if (this.networkManager != null) {
            this.networkManager.disconnect();
        }
    }

    public void handleNewlyCreatedModel(Repository repo) {
        ApplyMicroVersionMessage rootAndVertexCreation = new ApplyMicroVersionMessage();
        ArrayList<String> operations = new ArrayList<String>();
        UUID rootUuid = UUID.randomUUID();
        operations.add(rootUuid + "=createRoot(Title Root,Color 0xadd8e6ff,LastUser generated);");
        operations.add(UUID.randomUUID() + "=createVertex(Term " + rootUuid + ",X 425.0,Y 260.0,Height 0.0,Width 0.0,LastUser generated);");
        DeltaRepresentation dr = new DeltaRepresentation();
        dr.setOperationList(operations);
        rootAndVertexCreation.microVersion = dr.getOperationList();
        rootAndVertexCreation.id = repo.getId();
        System.out.println("NS: Sending ApplyMicroVersionMessages.. (For root of newly created model)");
        this.networkManager.sendMessage(rootAndVertexCreation);
    }
}

