/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.operations.mindmap;

import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class SetCrossReferenceNameOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final CrossReference crossRef;
    private final String oldName;
    private final String newName;

    public SetCrossReferenceNameOperation(CrossReference crossRef, String newName) {
        super("Change name");
        this.crossRef = crossRef;
        this.oldName = crossRef.getName();
        this.newName = newName;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.oldName.equals(this.newName);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.crossRef.setName(this.newName);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.crossRef.getName().equals(this.oldName)) {
            this.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.crossRef.getName().equals(this.newName)) {
            this.crossRef.setName(this.oldName);
        }
        return Status.OK_STATUS;
    }
}

