/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.policies;

import cmcm.application.editor.controller.graph.GraphModelPart;
import cmcm.application.editor.model.ItemCreationModel;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import cmcm.application.gui.DialogUtilities;
import com.google.common.collect.HashMultimap;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class CreateNewVertexOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    public void click(MouseEvent e) {
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ItemCreationModel cModel = (ItemCreationModel)viewer.getAdapter(ItemCreationModel.class);
        if (cModel == null) {
            throw new IllegalStateException("No ItemCreationModel bound to viewer!");
        }
        if (cModel.getPlacementState() != ItemCreationModel.PlacementState.VERTEX) {
            return;
        }
        IVisualPart part = (IVisualPart)viewer.getRootPart().getChildrenUnmodifiable().get(0);
        if (part instanceof GraphModelPart) {
            String title = DialogUtilities.showDialogAndGetString("Give Title", "Enter Title of Vertex");
            if (title.isBlank()) {
                cModel.setPlacementState(ItemCreationModel.PlacementState.NONE);
                return;
            }
            Vertex newVertex = new Vertex(new Root(title));
            Point2D mouseInLocal = part.getVisual().sceneToLocal(e.getSceneX(), e.getSceneY());
            newVertex.setGeometrics(new Rectangle(mouseInLocal.getX(), mouseInLocal.getY(), 0.0, 0.0));
            IRootPart root = this.getHost().getRoot();
            CreationPolicy cPolicy = (CreationPolicy)root.getAdapter(CreationPolicy.class);
            this.init((IPolicy)cPolicy);
            cPolicy.create((Object)newVertex, (IVisualPart)((GraphModelPart)part), HashMultimap.create());
            this.commit((IPolicy)cPolicy);
        }
        cModel.setPlacementState(ItemCreationModel.PlacementState.NONE);
    }
}

