/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.policies.mindmap;

import cmcm.application.editor.controller.graph.GraphModelPart;
import cmcm.application.editor.controller.graph.mindmap.MindmapTermPart;
import cmcm.application.editor.model.ItemCreationModel;
import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.editor.model.graph.layout.UndirectedLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.mindmap.Branch;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import cmcm.application.gui.DialogUtilities;
import com.google.common.collect.HashMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class CreateNewBranchOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    private MindmapTermPart sourcePart;
    private GraphModelPart graphPart;

    public void click(MouseEvent e) {
        if (!e.isPrimaryButtonDown()) {
            return;
        }
        this.sourcePart = (MindmapTermPart)this.getHost();
        IViewer viewer = this.sourcePart.getRoot().getViewer();
        ItemCreationModel cModel = (ItemCreationModel)viewer.getAdapter(ItemCreationModel.class);
        if (cModel.getPlacementState() != ItemCreationModel.PlacementState.LINK) {
            return;
        }
        IVisualPart part = (IVisualPart)this.sourcePart.getRoot().getChildrenUnmodifiable().get(0);
        if (part instanceof GraphModelPart) {
            this.graphPart = (GraphModelPart)part;
            String title = DialogUtilities.showDialogAndGetString("Give Title", "Enter Title of Branch");
            if (title.isBlank()) {
                cModel.setPlacementState(ItemCreationModel.PlacementState.NONE);
                return;
            }
            Vertex newTerm = new Vertex(new Branch(title, this.sourcePart.getModel().getColor()));
            Point2D mouseInLocal = part.getVisual().sceneToLocal(e.getSceneX(), e.getSceneY());
            ArrayList graphElements = (ArrayList)this.graphPart.getContent().getChildElements();
            for (LayoutElement elem : graphElements) {
                if (!(elem.getModelElement() instanceof Root)) continue;
                this.adjustGeometricsOfNewNodePrimitively(newTerm, mouseInLocal.getX(), mouseInLocal.getY(), this.sourcePart.getContent(), (Vertex)elem);
            }
            UndirectedLink newLink = new UndirectedLink((Branch)newTerm.getModelElement());
            newLink.connect(this.sourcePart.getContent(), newTerm);
            IRootPart root = this.sourcePart.getRoot();
            CreationPolicy vertexCreationPolicy = (CreationPolicy)root.getAdapter(CreationPolicy.class);
            this.init((IPolicy)vertexCreationPolicy);
            vertexCreationPolicy.create((Object)newTerm, (IVisualPart)this.graphPart, HashMultimap.create());
            this.commit((IPolicy)vertexCreationPolicy);
            CreationPolicy LinkCreationPolicy = (CreationPolicy)root.getAdapter((TypeToken)new TypeToken<CreationPolicy>(){});
            this.init((IPolicy)LinkCreationPolicy);
            LinkCreationPolicy.create((Object)newLink, (IVisualPart)this.graphPart, HashMultimap.create());
            this.commit((IPolicy)LinkCreationPolicy);
        }
        cModel.setPlacementState(ItemCreationModel.PlacementState.NONE);
    }

    private void adjustGeometricsOfNewNodePrimitively(Vertex newVertex, double mouseX, double mouseY, Vertex source, Vertex root) {
        int xShift = 120;
        int yShift = 35;
        int newVertexXModification = 0;
        int newVertexYModification = -35;
        int sourceAmountOfOutgoingBranches = 0;
        Point2D rootPoint = new Point2D(root.getGeometrics().getX(), root.getGeometrics().getY());
        if (!root.equals(source)) {
            Point2D sourcePoint = new Point2D(source.getGeometrics().getX(), source.getGeometrics().getY());
            for (AbstractLink link : source.getOutgoingLinks()) {
                if (!(link instanceof UndirectedLink)) continue;
                ++sourceAmountOfOutgoingBranches;
            }
            newVertexXModification = rootPoint.getX() > sourcePoint.getX() ? -120 : 132;
            newVertex.setGeometrics(new Rectangle(sourcePoint.getX() + (double)newVertexXModification, sourcePoint.getY() + (double)(newVertexYModification += sourceAmountOfOutgoingBranches * 35), 0.0, 0.0));
        } else {
            newVertex.setGeometrics(new Rectangle(mouseX, mouseY + 105.0, 0.0, 0.0));
        }
    }
}

