/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.policies.mindmap;

import cmcm.application.editor.controller.graph.AbstractLinkPart;
import cmcm.application.editor.controller.graph.AbstractVertexPart;
import cmcm.application.editor.controller.operations.mindmap.SetTermColorOperation;
import cmcm.application.editor.controller.operations.mindmap.SetTermTitleOperation;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import cmcm.application.editor.view.graph.AbstractVertexVisual;
import cmcm.application.gui.DialogUtilities;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;

public class ShowTermContextMenuOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    private AbstractVertexPart<AbstractVertexVisual> vertexPart;
    private boolean isRoot;

    public void click(MouseEvent e) {
        if (!e.isSecondaryButtonDown()) {
            return;
        }
        this.vertexPart = (AbstractVertexPart)this.getHost();
        this.isRoot = this.vertexPart.getModel() instanceof Root;
        ContextMenu ctxMenu = new ContextMenu(new MenuItem[]{this.createChangeTermTitleMenuItem(), this.createChangeColorMenu(), this.createDeleteTermMenuItem()});
        ctxMenu.show((Node)e.getTarget(), e.getScreenX(), e.getScreenY());
    }

    private MenuItem createChangeTermTitleMenuItem() {
        MenuItem changeTitleItem = new MenuItem("Change Title");
        changeTitleItem.setOnAction(e -> this.changeTermTitle());
        return changeTitleItem;
    }

    private void changeTermTitle() {
        try {
            String newTitle = DialogUtilities.showDialogAndGetString("Change title", "Enter new Title: ");
            if (newTitle.isBlank()) {
                return;
            }
            SetTermTitleOperation tOperation = new SetTermTitleOperation((Term)this.vertexPart.getModel(), newTitle);
            this.vertexPart.getRoot().getViewer().getDomain().execute((ITransactionalOperation)tOperation, null);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private Menu createChangeColorMenu() {
        Menu changeColorMenu = new Menu("Change color");
        ArrayList<Color> colors = new ArrayList<Color>(Arrays.asList(Color.BLACK, Color.RED, Color.DEEPSKYBLUE, Color.GOLD, Color.DARKSEAGREEN, Color.VIOLET, Color.ORANGE));
        if (this.isRoot) {
            colors.remove(Color.BLACK);
        }
        for (Color c : colors) {
            changeColorMenu.getItems().add((Object)this.getColorMenuItem(c.toString(), c));
        }
        return changeColorMenu;
    }

    private MenuItem getColorMenuItem(String name, Color c) {
        CheckMenuItem color = new CheckMenuItem("", (Node)new Rectangle(20.0, 20.0, (Paint)c));
        if (this.vertexPart.getContent().getModelElement().getColor().equals((Object)c)) {
            color.setSelected(true);
        }
        color.setOnAction(e -> this.changeTermColor(c));
        return color;
    }

    private void changeTermColor(Color newColor) {
        try {
            SetTermColorOperation tOperation = new SetTermColorOperation((Term)this.vertexPart.getModel(), newColor);
            this.vertexPart.getRoot().getViewer().getDomain().execute((ITransactionalOperation)tOperation, null);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private MenuItem createDeleteTermMenuItem() {
        MenuItem deleteItem = new MenuItem("Delete");
        if (this.isRoot || this.vertexPart.getContent().hasOutgoingLinks()) {
            deleteItem.setDisable(true);
        }
        deleteItem.setOnAction(ev -> this.deleteTerm());
        return deleteItem;
    }

    private void deleteTerm() {
        HoverModel hModel = (HoverModel)this.vertexPart.getViewer().getAdapter(HoverModel.class);
        if (this.vertexPart == hModel.getHover()) {
            hModel.clearHover();
        }
        IRootPart root = this.vertexPart.getRoot();
        DeletionPolicy dPolicy = (DeletionPolicy)root.getAdapter((TypeToken)new TypeToken<DeletionPolicy>(){});
        this.init((IPolicy)dPolicy);
        for (IVisualPart vPart : new ArrayList(this.vertexPart.getAnchoredsUnmodifiable())) {
            if (!(vPart instanceof AbstractLinkPart)) continue;
            ((AbstractLinkPart)vPart).getContent().disconnect();
            dPolicy.delete((IContentPart)vPart);
        }
        dPolicy.delete(this.vertexPart);
        this.commit((IPolicy)dPolicy);
    }
}

