/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.model.graph;

import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.editor.model.graph.layout.UndirectedLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.mindmap.Branch;
import cmcm.application.editor.model.graph.metamodel.mindmap.Root;
import javafx.scene.paint.Color;
import org.eclipse.gef.geometry.planar.Rectangle;

public class GraphModelExampleFactory {
    public GraphModel createMindmapExample() {
        return this.createMindmapExample(new GraphModel("MindmapExample"));
    }

    public GraphModel createEmptyExample() {
        return new GraphModel("EmptyExample");
    }

    public GraphModel createNewMindmapExample() {
        GraphModel gm = new GraphModel("MindmapExample");
        Vertex rootVertex = new Vertex(new Root("Root"));
        rootVertex.setGeometrics(new Rectangle(350.0, 250.0, 0.0, 0.0));
        gm.addChildElement(rootVertex);
        return gm;
    }

    private GraphModel createMindmapExample(GraphModel gm) {
        int AMOUNT_OF_BRANCHES = 6;
        Color BRANCH_COLOR_1 = Color.ORANGE;
        Color BRANCH_COLOR_2 = Color.RED;
        GraphModel example = gm;
        Vertex vertex1 = new Vertex(new Root("MainTopic"));
        vertex1.setGeometrics(new Rectangle(350.0, 250.0, 0.0, 0.0));
        example.addChildElement(vertex1);
        Vertex vertex = null;
        UndirectedLink link = null;
        Color c = BRANCH_COLOR_1;
        int i = 0;
        int x = 150;
        int y = 0;
        while (i < 6) {
            if (i == 3) {
                x = 550;
                y = 550 * 0;
                c = BRANCH_COLOR_2;
            }
            vertex = new Vertex(new Branch("Term " + i, c));
            vertex.setGeometrics(new Rectangle((double)x, (double)(150 + y * 100), 0.0, 0.0));
            example.addChildElement(vertex);
            link = new UndirectedLink((Branch)vertex.getModelElement());
            link.connect(vertex1, vertex);
            example.addChildElement(link);
            ++i;
            ++y;
        }
        Vertex vertex3 = new Vertex(new Branch("Term 5 Addition", c));
        vertex3.setGeometrics(new Rectangle(700.0, 400.0, 0.0, 0.0));
        example.addChildElement(vertex3);
        link = new UndirectedLink((Branch)vertex3.getModelElement());
        link.connect(vertex, vertex3);
        example.addChildElement(link);
        return example;
    }
}

