/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.view.graph;

import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.IShape;

public abstract class AbstractVertexVisual
extends Region {
    protected static final double HORIZONTAL_PADDING = 6.0;
    protected static final double VERTICAL_PADDING = 3.0;
    protected Text title;
    protected GeometryNode<IShape> shape;
    protected StackPane termPane;
    private Tooltip toolTip = new Tooltip("");

    public AbstractVertexVisual() {
        Tooltip.install((Node)this, (Tooltip)this.toolTip);
    }

    public double computeMinHeight(double width) {
        return this.termPane.minHeight(width);
    }

    public double computeMinWidth(double height) {
        return this.title.getLayoutBounds().getWidth() + 12.0;
    }

    protected double computePrefHeight(double width) {
        return this.minHeight(width);
    }

    protected double computePrefWidth(double height) {
        return this.minWidth(height);
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    public GeometryNode<?> getGeometryNode() {
        return this.shape;
    }

    public Text getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setColor(Color color) {
        this.shape.setFill((Paint)color);
        this.shape.setStroke((Paint)color);
    }

    public void setToolTipText(String text) {
        this.toolTip.setText("Last User: " + text);
    }

    public String getToolTipText() {
        return this.toolTip.getText();
    }
}

