/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.dl;

import cmcm.application.dl.DeltaOperationType;
import java.util.ArrayList;
import java.util.List;

public class DeltaOperation {
    private String identifier;
    private DeltaOperationType operationType;
    private String modelingArtifact;
    private List<String> attributes;

    public static DeltaOperation deserializeChangeFromTextualDelta(String operation) {
        DeltaOperation textualOperation = null;
        String id = operation.substring(0, operation.indexOf(".change"));
        String modelingObject = operation.substring(operation.indexOf(".change") + 7, operation.indexOf("("));
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add(operation.substring(operation.indexOf("(") + 1, operation.length() - 2));
        textualOperation = new DeltaOperation(id, DeltaOperationType.change, modelingObject, attributeList);
        return textualOperation;
    }

    public static DeltaOperation deserializeCreationFromTextualDelta(String operation) {
        DeltaOperation textualOperation = null;
        String id = operation.substring(0, operation.indexOf("=create"));
        String modelingObject = operation.substring(operation.indexOf("=create") + 7, operation.indexOf("("));
        String[] attributeListInitial = operation.substring(operation.indexOf("(") + 1, operation.length() - 2).split(",");
        ArrayList<String> attributeList = new ArrayList<String>();
        String[] stringArray = attributeListInitial;
        int n = attributeListInitial.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            attributeList.add(str);
            ++n2;
        }
        textualOperation = new DeltaOperation(id, DeltaOperationType.create, modelingObject, attributeList);
        return textualOperation;
    }

    public static DeltaOperation deserializeDeletionFromTextualDelta(String operation) {
        DeltaOperation textualOperation = null;
        String id = operation.substring(0, operation.indexOf(".delete"));
        String modelingObject = "none";
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("none");
        textualOperation = new DeltaOperation(id, DeltaOperationType.change, "none", attributeList);
        return textualOperation;
    }

    public static String getOperationType(String operation) {
        if (operation.contains("=create")) {
            return "create";
        }
        if (operation.contains(".change")) {
            return "change";
        }
        if (operation.contains(".delete")) {
            return "delete";
        }
        return "unknown";
    }

    public static String serializeToTextualDelta(DeltaOperation operation) {
        String textualOperation = "";
        if (operation.getOperationType().equals((Object)DeltaOperationType.create)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "=" + (Object)((Object)DeltaOperationType.create) + operation.getModelingArtifact() + "(";
            if (!operation.getAttributes().isEmpty()) {
                for (String attr : operation.getAttributes()) {
                    textualOperation = String.valueOf(textualOperation) + attr + ",";
                }
                textualOperation = textualOperation.substring(0, textualOperation.length() - 1);
            }
            textualOperation = String.valueOf(textualOperation) + ");";
        } else if (operation.getOperationType().equals((Object)DeltaOperationType.change)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "." + (Object)((Object)DeltaOperationType.change) + "(" + operation.getAttributes().get(0) + ");";
        } else if (operation.getOperationType().equals((Object)DeltaOperationType.delete)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "." + (Object)((Object)DeltaOperationType.delete) + "();";
        }
        return textualOperation;
    }

    public DeltaOperation() {
    }

    public DeltaOperation(String id, DeltaOperationType operation, String modelingObject, List<String> attributeList) {
        this.identifier = id;
        this.operationType = operation;
        this.modelingArtifact = modelingObject;
        this.attributes = attributeList;
    }

    public String getAttribute() {
        return this.attributes.get(0);
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getModelingArtifact() {
        return this.modelingArtifact;
    }

    public DeltaOperationType getOperationType() {
        return this.operationType;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setModelingArtifact(String modelingArtifact) {
        this.modelingArtifact = modelingArtifact;
    }

    public void setOperationType(DeltaOperationType operationType) {
        this.operationType = operationType;
    }
}

