/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.operations.mindmap;

import cmcm.application.editor.model.graph.metamodel.mindmap.Term;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class SetTermTitleOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final Term term;
    private final String oldTitle;
    private final String newTitle;

    public SetTermTitleOperation(Term term, String newName) {
        super("Change title");
        this.term = term;
        this.oldTitle = term.getTitle();
        this.newTitle = newName;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.oldTitle.equals(this.newTitle) || this.newTitle.isBlank();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.term.setTitle(this.newTitle);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.term.getTitle().equals(this.oldTitle)) {
            this.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.term.getTitle().equals(this.newTitle)) {
            this.term.setTitle(this.oldTitle);
        }
        return Status.OK_STATUS;
    }
}

