/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.policies.mindmap;

import cmcm.application.editor.controller.graph.AbstractLinkPart;
import cmcm.application.editor.controller.operations.mindmap.SetCrossReferenceBidirectionalOperation;
import cmcm.application.editor.controller.operations.mindmap.SetCrossReferenceColorOperation;
import cmcm.application.editor.controller.operations.mindmap.SetCrossReferenceNameOperation;
import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.DirectedLink;
import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import cmcm.application.editor.view.graph.AbstractLinkVisual;
import cmcm.application.gui.DialogUtilities;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.DeletionPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;

public class ShowCrossReferenceContextMenuOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    private AbstractLinkPart<AbstractLinkVisual> selectedLinkPart;
    private DirectedLink selectedDirectedLink;
    private CrossReference selectedCrossReference;

    public void click(MouseEvent e) {
        if (!e.isSecondaryButtonDown()) {
            return;
        }
        HoverModel hModel = (HoverModel)this.getHost().getViewer().getAdapter(HoverModel.class);
        if (this.getHost() == hModel.getHover()) {
            hModel.clearHover();
        }
        this.selectedLinkPart = (AbstractLinkPart)this.getHost();
        AbstractLink elem = this.selectedLinkPart.getContent();
        if (elem instanceof DirectedLink) {
            this.selectedDirectedLink = (DirectedLink)elem;
            this.selectedCrossReference = this.selectedDirectedLink.getModelElement();
            ContextMenu ctxMenu = new ContextMenu(new MenuItem[]{this.createChangeCrossReferenceNameMenuItem(), this.createChangeColorMenu(), this.createCrossReferenceBidirectionalMenuItem(), this.createDeleteCrossReferenceMenuItem()});
            ctxMenu.show((Node)e.getTarget(), e.getScreenX(), e.getScreenY());
        }
    }

    private MenuItem createChangeCrossReferenceNameMenuItem() {
        MenuItem changeTextItem = new MenuItem("Change Name");
        changeTextItem.setOnAction(e -> this.changeCrossReferenceName(DialogUtilities.showDialogAndGetString("Change name", "Enter new Name: ")));
        return changeTextItem;
    }

    private void changeCrossReferenceName(String newName) {
        try {
            SetCrossReferenceNameOperation tOperation = new SetCrossReferenceNameOperation(this.selectedCrossReference, newName);
            this.selectedLinkPart.getRoot().getViewer().getDomain().execute((ITransactionalOperation)tOperation, null);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private Menu createChangeColorMenu() {
        Menu changeColorMenu = new Menu("Change color");
        ArrayList<Color> colors = new ArrayList<Color>(Arrays.asList(Color.BLACK, Color.RED, Color.DEEPSKYBLUE, Color.GOLD, Color.DARKSEAGREEN, Color.VIOLET, Color.ORANGE));
        for (Color c : colors) {
            changeColorMenu.getItems().add((Object)this.createCrossReferenceColorMenuItem(c.toString(), c));
        }
        return changeColorMenu;
    }

    private MenuItem createCrossReferenceColorMenuItem(String name, Color c) {
        CheckMenuItem color = new CheckMenuItem("", (Node)new Rectangle(20.0, 20.0, (Paint)c));
        if (this.selectedCrossReference.getColor().equals((Object)c)) {
            color.setSelected(true);
        }
        color.setOnAction(e -> this.changeCrossReferenceColor(c));
        return color;
    }

    private void changeCrossReferenceColor(Color newColor) {
        try {
            SetCrossReferenceColorOperation tOperation = new SetCrossReferenceColorOperation((CrossReference)this.selectedLinkPart.getModel(), newColor);
            this.selectedLinkPart.getRoot().getViewer().getDomain().execute((ITransactionalOperation)tOperation, null);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private MenuItem createCrossReferenceBidirectionalMenuItem() {
        boolean isBidirectional = this.selectedCrossReference.isBidirectional();
        CheckMenuItem changeBidirectionalItem = new CheckMenuItem("Bidirecitonal");
        changeBidirectionalItem.setSelected(isBidirectional);
        changeBidirectionalItem.setOnAction(e -> this.changeCrossReferenceBidirectionality(!isBidirectional));
        return changeBidirectionalItem;
    }

    private void changeCrossReferenceBidirectionality(boolean bidirectional) {
        try {
            SetCrossReferenceBidirectionalOperation tOperation = new SetCrossReferenceBidirectionalOperation(this.selectedCrossReference, bidirectional);
            this.selectedLinkPart.getRoot().getViewer().getDomain().execute((ITransactionalOperation)tOperation, null);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
    }

    private MenuItem createDeleteCrossReferenceMenuItem() {
        MenuItem deleteItem = new MenuItem("Delete");
        deleteItem.setOnAction(ev -> this.deleteCrossReference());
        return deleteItem;
    }

    private void deleteCrossReference() {
        this.selectedDirectedLink.disconnect();
        DeletionPolicy dPolicy = (DeletionPolicy)this.selectedLinkPart.getRoot().getAdapter((TypeToken)new TypeToken<DeletionPolicy>(){});
        this.init((IPolicy)dPolicy);
        dPolicy.delete(this.selectedLinkPart);
        this.commit((IPolicy)dPolicy);
    }
}

