/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.graph;

import cmcm.application.editor.model.graph.layout.AbstractLink;
import cmcm.application.editor.model.graph.layout.Vertex;
import cmcm.application.editor.model.graph.metamodel.ModelElement;
import cmcm.application.editor.view.graph.AbstractLinkVisual;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public abstract class AbstractLinkPart<T extends AbstractLinkVisual>
extends AbstractContentPart<T>
implements ITransformableContentPart<T>,
PropertyChangeListener {
    protected static final String START_ROLE = "START";
    protected static final String END_ROLE = "END";

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap<Vertex, String> anchorages = HashMultimap.create();
        anchorages.put(this.getContent().getSource(), START_ROLE);
        anchorages.put(this.getContent().getTarget(), END_ROLE);
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        Provider adapter = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IAnchor>>(){}));
        if (adapter == null) {
            throw new IllegalStateException("No adapter for <" + anchorage.getClass() + "> found.");
        }
        IAnchor anchor = (IAnchor)adapter.get();
        if (role.equals(START_ROLE)) {
            ((AbstractLinkVisual)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals(END_ROLE)) {
            ((AbstractLinkVisual)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalArgumentException("Role \"" + role + "\" invalid. (Has to be START or END)");
        }
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        if (role.equals(START_ROLE)) {
            ((AbstractLinkVisual)this.getVisual()).setStartPoint(((AbstractLinkVisual)this.getVisual()).getStartPoint());
        } else if (role.equals(END_ROLE)) {
            ((AbstractLinkVisual)this.getVisual()).setEndPoint(((AbstractLinkVisual)this.getVisual()).getEndPoint());
        } else {
            throw new IllegalArgumentException("Role \"" + role + "\" invalid. (Has to be START or END)");
        }
    }

    public Affine getContentTransform() {
        return null;
    }

    public void setContentTransform(Affine totalTransform) {
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().addPropertyChangeListener(this);
        this.getModel().addPropertyChangeListener(this);
    }

    protected void doDeactivate() {
        this.getContent().removePropertyChangeListener(this);
        this.getModel().removePropertyChangeListener(this);
        super.doDeactivate();
    }

    public AbstractLink getContent() {
        return (AbstractLink)super.getContent();
    }

    public abstract ModelElement getModel();
}

