/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.network;

import cmcm.application.dl.DeltaRepresentation;
import cmcm.application.network.NetworkService;
import cmcm.application.network.shared.messages.CoMoMessage;
import cmcm.application.network.shared.messages.MessageType;
import cmcm.application.network.shared.messages.RequestMessage;
import cmcm.application.network.shared.messages.ResponseMessage;
import cmcm.application.network.shared.messages.administration.IAdministrationMessage;
import cmcm.application.network.shared.messages.dto.Repository;
import cmcm.application.network.shared.messages.dto.RepositoryDelta;
import cmcm.application.network.shared.messages.dto.User;
import cmcm.application.network.shared.messages.repository.IRepositoryMessage;
import cmcm.application.network.shared.messages.repository.request.CreateRepositoryMessage;
import cmcm.application.network.shared.messages.repository.response.ApplyMicroVersionMessage;
import cmcm.application.network.shared.messages.repository.response.GetRepositoryMessage;
import cmcm.application.network.shared.messages.user.IUserMessage;
import cmcm.application.network.shared.messages.user.request.CreateUserMessage;
import cmcm.application.network.shared.messages.user.response.GetUserMessage;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class NetworkManager
implements IMqttMessageListener {
    private static final String CONN_USERNAME = "admin";
    private static final String CONN_PASSWORD = "e1t04wa3";
    private NetworkService networkService;
    private MqttClient client;
    private final UUID clientID = UUID.randomUUID();
    private final Gson gson = new Gson();
    private final List<RequestMessage> openRequests = new ArrayList<RequestMessage>();
    private final List<RequestMessage> requests = new ArrayList<RequestMessage>();
    private String token;
    private Repository createdRepository;
    private CreateRepositoryMessage createdRepositorySourceMessage;
    private boolean versionSave;

    public NetworkManager(String serverURI, NetworkService ns) {
        this.networkService = ns;
        this.connect(serverURI);
    }

    public void connect(String serverURI) {
        try {
            if (this.client != null && this.client.isConnected() && this.client.getCurrentServerURI().equals(serverURI)) {
                return;
            }
            this.client = new MqttClient(serverURI, MqttClient.generateClientId(), (MqttClientPersistence)new MemoryPersistence());
            this.client.connect(this.getConnectionOptions());
            this.client.subscribe("client/" + this.clientID.toString(), (IMqttMessageListener)this);
            System.out.println("NM: Connection worked out, Subscribed to: client/" + this.clientID.toString());
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.client != null && !this.client.isConnected()) {
            return;
        }
        try {
            this.client.disconnect();
            System.out.println("NM: Disconnect worked out");
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(RequestMessage msg) {
        msg.setIssuer(this.clientID);
        msg.setMessageId(UUID.randomUUID());
        msg.setAuthToken(this.token);
        this.openRequests.add(msg);
        this.requests.add(msg);
        String content = this.gson.toJson((Object)msg);
        MqttMessage mqttMsg = new MqttMessage(content.getBytes());
        mqttMsg.setQos(2);
        String topic = "";
        if (msg instanceof IRepositoryMessage) {
            topic = "repository/v1";
        } else if (msg instanceof IUserMessage) {
            topic = "user/v1";
        } else if (msg instanceof IAdministrationMessage) {
            topic = "administration/v1";
        }
        try {
            MqttClient sender = new MqttClient(this.client.getCurrentServerURI(), MqttClient.generateClientId(), (MqttClientPersistence)new MemoryPersistence());
            sender.connect(this.getConnectionOptions());
            sender.publish("api/" + topic, mqttMsg);
            System.out.println("NM: Message sent: \n\tTopic: " + topic + "\n\tMessage: " + mqttMsg);
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }

    public void messageArrived(String topic, MqttMessage msg) throws Exception {
        System.out.println("NM: message arrived: \n\tTopic " + topic + "\n\tMessage: " + msg.toString());
        CoMoMessage cMsg = (CoMoMessage)this.gson.fromJson(msg.toString(), CoMoMessage.class);
        Class cMsgClass = cMsg.getType().getMessageClass();
        ResponseMessage response = (ResponseMessage)this.gson.fromJson(msg.toString(), cMsgClass);
        if (response.getAuthToken() != null) {
            this.token = response.getAuthToken();
        }
        switch (response.getType()) {
            case GetUserResp: {
                this.interpretGetUserResponse((GetUserMessage)response);
                break;
            }
            case GetRepositoryResp: {
                this.interpretGetRepositoryResponse((GetRepositoryMessage)response);
                break;
            }
            case ApplyMicroVersionResp: {
                this.interpretApplyMicroVersionResponse((ApplyMicroVersionMessage)response);
                break;
            }
            case Status: {
                this.interpretStatusResponse(response);
                break;
            }
            default: {
                System.out.println("NM: Recieved Response is unknown");
                return;
            }
        }
        RequestMessage rMsg = this.getOwnOpenRequestOfResponse(response);
        if (rMsg != null) {
            this.openRequests.remove(rMsg);
        }
    }

    private void interpretGetUserResponse(GetUserMessage userMsg) throws MqttException {
        User[] users = (User[])userMsg.getData();
        if (users.length > 0) {
            if (userMsg.getAuthToken() == null) {
                this.networkService.handleRegister();
                CreateUserMessage createUserMsg = (CreateUserMessage)this.getOwnRequestOfResponse(userMsg);
                this.networkService.requestLogin(createUserMsg.getEmail(), createUserMsg.getPassword().toCharArray());
                return;
            }
            this.client.subscribe("client/" + users[0].getId().toString(), (IMqttMessageListener)this);
            System.out.println("NM: User Login successful - subscribed to client/" + users[0].getId().toString());
            this.networkService.handleLogin(users[0]);
        }
        cmcm.application.network.shared.messages.repository.request.GetRepositoryMessage repoMsg = new cmcm.application.network.shared.messages.repository.request.GetRepositoryMessage();
        System.out.println("NM: Requesting Repositories of User");
        this.sendMessage(repoMsg);
    }

    private void interpretGetRepositoryResponse(GetRepositoryMessage repMsg) throws MqttException {
        ArrayList<Repository> repos = new ArrayList<Repository>(Arrays.asList((Repository[])repMsg.getData()));
        if (repMsg.isActiveDelta()) {
            Repository repo = repos.get(0);
            DeltaRepresentation deltaRepr = repo.getModel();
            if (this.versionSave) {
                this.versionSave = false;
                this.networkService.handleModelForSaving(repo, "");
                return;
            }
            if (this.createdRepository != null && repo.getId().equals(this.createdRepository.getId()) && deltaRepr.getOperationList().isEmpty()) {
                this.createdRepository = null;
                this.requests.remove(this.createdRepositorySourceMessage);
                this.createdRepositorySourceMessage = null;
                this.networkService.handleNewlyCreatedModel(repo);
                return;
            }
            this.networkService.setRepository(repo);
            this.client.subscribe("repository/" + repo.getId().toString(), (IMqttMessageListener)this);
            this.networkService.handleApplyMacroVersion(deltaRepr);
        } else {
            Repository r = this.getNewlyCreatedRepositoryFromModellist(repos);
            if (r != null && this.createdRepositorySourceMessage != null) {
                this.networkService.requestActiveDeltaOfModel(r);
                this.createdRepository = r;
            }
            this.networkService.handleModelList(repos);
        }
    }

    private void interpretApplyMicroVersionResponse(ApplyMicroVersionMessage applyMsg) {
        if (this.isResponseForOwnRequest(applyMsg)) {
            return;
        }
        RepositoryDelta delta = ((RepositoryDelta[])applyMsg.getData())[0];
        DeltaRepresentation deltaRepr = new DeltaRepresentation();
        deltaRepr.setOperationList((List)delta.getOperations());
        this.networkService.handleApplyMicroVersion(deltaRepr);
    }

    private void interpretStatusResponse(ResponseMessage statusMsg) {
        System.out.println("NM: Status Message \"" + statusMsg.getStatusCode() + "\" recieved");
        if (this.isResponseForOwnOpenRequest(statusMsg)) {
            RequestMessage request = this.getOwnOpenRequestOfResponse(statusMsg);
            System.out.println("\tTo the following Request: " + request.toString());
            if (request.getType().equals((Object)MessageType.CreateRepository)) {
                this.networkService.requestModelList();
                this.createdRepositorySourceMessage = (CreateRepositoryMessage)request;
            }
            this.openRequests.remove(request);
        }
    }

    private MqttConnectOptions getConnectionOptions() {
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setAutomaticReconnect(true);
        connOpts.setCleanSession(true);
        connOpts.setConnectionTimeout(0);
        connOpts.setUserName(CONN_USERNAME);
        connOpts.setPassword(CONN_PASSWORD.toCharArray());
        return connOpts;
    }

    private boolean isResponseForOwnRequest(ResponseMessage response) {
        return this.getOwnRequestOfResponse(response) != null;
    }

    private RequestMessage getOwnRequestOfResponse(ResponseMessage response) {
        for (RequestMessage r : this.openRequests) {
            if (!r.getMessageId().equals(response.getRequestId())) continue;
            return r;
        }
        return null;
    }

    private boolean isResponseForOwnOpenRequest(ResponseMessage response) {
        return this.getOwnOpenRequestOfResponse(response) != null;
    }

    private RequestMessage getOwnOpenRequestOfResponse(ResponseMessage response) {
        for (RequestMessage r : this.openRequests) {
            if (!r.getMessageId().equals(response.getRequestId())) continue;
            return r;
        }
        return null;
    }

    private Repository getNewlyCreatedRepositoryFromModellist(List<Repository> repos) {
        for (RequestMessage rMsg : this.requests) {
            if (rMsg.getType() != MessageType.CreateRepository) continue;
            CreateRepositoryMessage createRepoMsg = (CreateRepositoryMessage)rMsg;
            for (Repository r : repos) {
                if (!r.getName().equals(createRepoMsg.getName())) continue;
                return r;
            }
        }
        return null;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setVersionSave(boolean versionSave) {
        this.versionSave = versionSave;
    }
}

