/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.dl;

import cmcm.application.dl.DeltaOperation;
import cmcm.application.dl.DeltaOperationType;
import cmcm.application.dl.DeltaRepresentation;
import java.util.ArrayList;
import java.util.List;

public final class DeltaOperationUtilities {
    private DeltaOperationUtilities() {
    }

    public static Boolean isValidDeltaOperationType(String operationAsString) {
        if (DeltaOperation.getOperationType(operationAsString) != "unknown") {
            return true;
        }
        return false;
    }

    public static DeltaOperationType getOperationType(String deltaOperation) {
        if (deltaOperation.contains("=create")) {
            return DeltaOperationType.create;
        }
        if (deltaOperation.contains(".delete")) {
            return DeltaOperationType.delete;
        }
        return DeltaOperationType.change;
    }

    public static void printDeltaOperationToConsole(DeltaOperation deltaOp) {
        System.out.println("DeltaOperation: [[[ID " + deltaOp.getIdentifier() + ", " + "Op " + (Object)((Object)deltaOp.getOperationType()) + ", " + "Elem " + deltaOp.getModelingArtifact() + ", " + "Att " + deltaOp.getAttributes() + "]]]");
    }

    public static String getAttributeValue(String attribute, String desiredAttribute) {
        return attribute.substring(desiredAttribute.length() + 1);
    }

    public static String getAttributeValue(List<String> attributes, String desiredAttribute) {
        for (String attribute : attributes) {
            if (!attribute.contains(desiredAttribute)) continue;
            return DeltaOperationUtilities.getAttributeValue(attribute, desiredAttribute);
        }
        return "";
    }

    public static DeltaOperation convertToDeltaOperation(String operationAsString) {
        DeltaOperation deltaOp = null;
        switch (DeltaOperationUtilities.getOperationType(operationAsString)) {
            case create: {
                deltaOp = DeltaOperation.deserializeCreationFromTextualDelta(operationAsString);
                break;
            }
            case delete: {
                deltaOp = DeltaOperation.deserializeDeletionFromTextualDelta(operationAsString);
                deltaOp.setOperationType(DeltaOperationType.delete);
                break;
            }
            case change: {
                deltaOp = DeltaOperationUtilities.deserializeChangeFromTextualDelta(operationAsString);
                break;
            }
            default: {
                System.out.println("DeltaOperation unknown");
            }
        }
        return deltaOp;
    }

    public static String createAttributeString(String attribute, String value) {
        return String.valueOf(attribute) + " " + value;
    }

    public static ArrayList<String> createAttributeList(String ... attributes) {
        ArrayList<String> attributeList = new ArrayList<String>();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            attributeList.add(attr);
            ++n2;
        }
        return attributeList;
    }

    public static DeltaRepresentation deltaOperationsToDeltaRepresentation(DeltaOperation ... dOps) {
        DeltaRepresentation dR = new DeltaRepresentation();
        ArrayList<String> deltaOperationList = new ArrayList<String>();
        DeltaOperation[] deltaOperationArray = dOps;
        int n = dOps.length;
        int n2 = 0;
        while (n2 < n) {
            DeltaOperation dOp = deltaOperationArray[n2];
            deltaOperationList.add(DeltaOperationUtilities.serializeToTextualDelta(dOp));
            ++n2;
        }
        dR.setOperationList(deltaOperationList);
        return dR;
    }

    public static String serializeToTextualDelta(DeltaOperation operation) {
        String textualOperation = "";
        if (operation.getOperationType().equals((Object)DeltaOperationType.create)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "=" + (Object)((Object)DeltaOperationType.create) + operation.getModelingArtifact() + "(";
            if (!operation.getAttributes().isEmpty()) {
                for (String attr : operation.getAttributes()) {
                    textualOperation = String.valueOf(textualOperation) + attr + ",";
                }
                textualOperation = textualOperation.substring(0, textualOperation.length() - 1);
            }
            textualOperation = String.valueOf(textualOperation) + ");";
        } else if (operation.getOperationType().equals((Object)DeltaOperationType.change)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "." + (Object)((Object)DeltaOperationType.change) + "(";
            if (!operation.getAttributes().isEmpty()) {
                for (String attr : operation.getAttributes()) {
                    textualOperation = String.valueOf(textualOperation) + attr + ",";
                }
                textualOperation = textualOperation.substring(0, textualOperation.length() - 1);
            }
            textualOperation = String.valueOf(textualOperation) + ");";
        } else if (operation.getOperationType().equals((Object)DeltaOperationType.delete)) {
            textualOperation = String.valueOf(operation.getIdentifier()) + "." + (Object)((Object)DeltaOperationType.delete) + "();";
        }
        return textualOperation;
    }

    public static DeltaOperation deserializeChangeFromTextualDelta(String operation) {
        DeltaOperation textualOperation = null;
        String id = operation.substring(0, operation.indexOf(".change"));
        String modelingObject = operation.substring(operation.indexOf(".change") + 7, operation.indexOf("("));
        String[] attributeListInitial = operation.substring(operation.indexOf("(") + 1, operation.length() - 2).split(",");
        ArrayList<String> attributeList = new ArrayList<String>();
        String[] stringArray = attributeListInitial;
        int n = attributeListInitial.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            attributeList.add(str);
            ++n2;
        }
        textualOperation = new DeltaOperation(id, DeltaOperationType.change, modelingObject, attributeList);
        return textualOperation;
    }
}

