/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.feedback;

import cmcm.application.editor.view.graph.mindmap.BranchLinkVisual;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.StaticAnchor;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.AbstractFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class LinkFeedbackPart
extends AbstractFeedbackPart<Node> {
    protected Node doCreateVisual() {
        return new BranchLinkVisual();
    }

    protected void doRefreshVisual(Node visual) {
    }

    public BranchLinkVisual getVisual() {
        return (BranchLinkVisual)super.getVisual();
    }

    public void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        Provider adapter = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IAnchor>>(){}));
        if (adapter == null) {
            throw new IllegalStateException("No adapter found for <" + anchorage.getClass() + ">.");
        }
        IAnchor anchor = (IAnchor)adapter.get();
        this.getVisual().setStartAnchor(anchor);
        MousePositionAnchor endAnchor = new MousePositionAnchor(FX2Geometry.toPoint((Point2D)this.getVisual().localToScene(Geometry2FX.toFXPoint((Point)this.getVisual().getStartPoint()))));
        endAnchor.init();
        this.getVisual().setEndAnchor((IAnchor)endAnchor);
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        this.getVisual().setStartPoint(this.getVisual().getStartPoint());
        MousePositionAnchor mpEndAnchor = (MousePositionAnchor)this.getVisual().getEndAnchor();
        mpEndAnchor.dispose();
        this.getVisual().setEndPoint(this.getVisual().getEndPoint());
    }

    private class MousePositionAnchor
    extends StaticAnchor
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            Point v = new Point(event.getSceneX(), event.getSceneY());
            this.referencePositionProperty().setValue((Object)v);
        }

        public MousePositionAnchor(Point referencePosition) {
            super(referencePosition);
        }

        public void init() {
            LinkFeedbackPart.this.getRoot().getVisual().getScene().addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
        }

        public void dispose() {
            LinkFeedbackPart.this.getRoot().getVisual().getScene().removeEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
        }
    }
}

