/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.editor.controller.operations.mindmap;

import cmcm.application.editor.model.graph.metamodel.mindmap.CrossReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;

public class SetCrossReferenceBidirectionalOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final CrossReference crossRef;
    private final boolean oldValue;
    private final boolean newValue;

    public SetCrossReferenceBidirectionalOperation(CrossReference crossRef, boolean newValue) {
        super("Change Bidirectionality");
        this.crossRef = crossRef;
        this.oldValue = crossRef.isBidirectional();
        this.newValue = newValue;
    }

    public boolean isContentRelevant() {
        return true;
    }

    public boolean isNoOp() {
        return this.oldValue == this.newValue;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.crossRef.setBidirectional(this.newValue);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.crossRef.isBidirectional() == this.oldValue) {
            return this.execute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.crossRef.isBidirectional() == this.newValue) {
            this.crossRef.setBidirectional(this.oldValue);
        }
        return Status.OK_STATUS;
    }
}

