/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.gui.editor;

import cmcm.application.dl.DeltaRepresentation;
import cmcm.application.dl.applier.DeltaApplier;
import cmcm.application.dl.calculator.DeltaChangeListener;
import cmcm.application.editor.controller.GraphModelModule;
import cmcm.application.editor.model.ItemCreationModel;
import cmcm.application.editor.model.graph.Element;
import cmcm.application.editor.model.graph.GraphModel;
import cmcm.application.editor.model.graph.GraphModelExampleFactory;
import cmcm.application.editor.model.graph.layout.LayoutElement;
import cmcm.application.gui.DialogUtilities;
import cmcm.application.gui.Model;
import cmcm.application.gui.editor.EditorView;
import cmcm.application.network.NetworkService;
import cmcm.application.network.shared.messages.dto.Repository;
import cmcm.resources.CmcmResource;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javax.imageio.ImageIO;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.domain.HistoricizingDomain;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.models.SelectionModel;

public class EditorController {
    private EditorView eView;
    private Model model = new Model((HistoricizingDomain)Guice.createInjector((Module[])new Module[]{new GraphModelModule()}).getInstance(IDomain.class));
    private NetworkService networkService;

    public EditorController(NetworkService ns) {
        this.eView = new EditorView((InfiniteCanvas)this.model.getContentViewer().getCanvas());
        this.model.getHDomain().activate();
        this.model.addPropertyChangeListener(this.eView);
        this.networkService = ns;
        ns.setEditorController(this);
        this.registerEvents();
        this.registerBehaviour();
        this.setContentsWithExample();
    }

    private void setContentsWithExample() {
        GraphModelExampleFactory gmFactory = new GraphModelExampleFactory();
        GraphModel gm = gmFactory.createMindmapExample();
        this.model.getContentViewer().getContents().setAll(new Object[]{gm});
    }

    private void registerEvents() {
        this.eView.setUndoFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                this.model.getHDomain().getOperationHistory().undo(this.model.getHDomain().getUndoContext(), null, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }));
        this.eView.setRedoFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                this.model.getHDomain().getOperationHistory().redo(this.model.getHDomain().getUndoContext(), null, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }));
        this.eView.setLoginFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> DialogUtilities.showLoginDialog(auth -> this.networkService.requestLogin(auth.getEmail(), auth.getPassword()))));
        this.eView.setRegisterFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> DialogUtilities.showRegisterDialog(auth -> this.networkService.requestRegister(auth.getUsername(), auth.getEmail(), auth.getPassword()))));
        this.eView.setModelListFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> this.networkService.requestModelList()));
        this.eView.setSaveFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> this.networkService.requestSaveModel()));
        this.eView.setExportAsPNGFunctionality((EventHandler<ActionEvent>)((EventHandler)e -> this.saveModelAsPNG()));
    }

    private void registerBehaviour() {
        this.eView.setGridBehaviour((ChangeListener<? super Boolean>)((ChangeListener)(e, oldVal, newVal) -> ((GridModel)this.model.getContentViewer().getAdapter(GridModel.class)).setShowGrid(newVal.booleanValue())));
        this.eView.setCreateVertexBehaviour((ChangeListener<? super Boolean>)((ChangeListener)(e, oldVal, newVal) -> this.model.getItemCreationModel().setPlacementState(newVal != false ? ItemCreationModel.PlacementState.VERTEX : ItemCreationModel.PlacementState.NONE)));
        this.eView.setCreateBranchBehaviour((ChangeListener<? super Boolean>)((ChangeListener)(e, oldVal, newVal) -> this.model.getItemCreationModel().setPlacementState(newVal != false ? ItemCreationModel.PlacementState.LINK : ItemCreationModel.PlacementState.NONE)));
        this.eView.setCreateCrossReferenceBehaviour((ChangeListener<? super Boolean>)((ChangeListener)(e, oldVal, newVal) -> this.model.getItemCreationModel().setPlacementState(newVal != false ? ItemCreationModel.PlacementState.DIRECTEDLINK : ItemCreationModel.PlacementState.NONE)));
        this.model.getItemCreationModel().getPlacementStateProperty().addListener((e, oldVal, newVal) -> {
            Toggle selectedToggle;
            if (ItemCreationModel.PlacementState.NONE == newVal && (selectedToggle = this.eView.getPaletteToggleGroup().getSelectedToggle()) != null) {
                selectedToggle.setSelected(false);
            }
        });
        this.model.getHDomain().getOperationHistory().addOperationHistoryListener(e -> {
            IUndoContext ctx = this.model.getHDomain().getUndoContext();
            this.eView.getUndoNode().setDisable(!e.getHistory().canUndo(ctx));
        });
        this.model.getHDomain().getOperationHistory().addOperationHistoryListener(e -> {
            IUndoContext ctx = this.model.getHDomain().getUndoContext();
            this.eView.getRedoNode().setDisable(!e.getHistory().canRedo(ctx));
        });
    }

    public void loadModel(final GraphModel gm) {
        this.model.getHDomain().getOperationHistory().dispose(this.model.getHDomain().getUndoContext(), true, true, true);
        System.out.println("EC: Loading new Model");
        this.model.setGraphModel(gm);
        this.model.setModelOpen(true);
        DeltaChangeListener dCL = new DeltaChangeListener(gm);
        dCL.setNetworkService(this.networkService);
        this.model.setDeltaChangeListener(dCL);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditorController.this.model.getContentViewer().getContents().setAll(new Object[]{gm});
                EditorController.this.eView.load(EditorController.this.model.getEditorScene());
                System.out.println("EC: Finished loading new Model");
            }
        });
    }

    public void updateModel(final DeltaRepresentation deltaRepr) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DeltaApplier applier = new DeltaApplier(EditorController.this.model.getGraphModel());
                applier.startUpdateMode(EditorController.this.model.getDeltaChangeListener().getExcludedElements());
                applier.applyDelta(deltaRepr);
                boolean updateRequired = false;
                ArrayList<Element> newElems = applier.getAllCreatedElements();
                for (Element newElem : newElems) {
                    if (!updateRequired && newElem instanceof LayoutElement) {
                        updateRequired = true;
                    }
                    newElem.addPropertyChangeListener(EditorController.this.model.getDeltaChangeListener());
                }
                ArrayList<Element> deletedElems = applier.getAllDeletedElements();
                for (Element deletedElem : deletedElems) {
                    if (!updateRequired && deletedElem instanceof LayoutElement) {
                        updateRequired = true;
                    }
                    deletedElem.removePropertyChangeListener(EditorController.this.model.getDeltaChangeListener());
                }
                if (updateRequired) {
                    EditorController.this.model.getContentViewer().getContents().clear();
                    EditorController.this.model.getContentViewer().getContents().setAll(new Object[]{EditorController.this.model.getGraphModel()});
                }
            }
        });
    }

    public void saveModelAsPNG() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String result = DialogUtilities.showDialogWithContentAndGetString("Generate PNG of model", "Insert name for new PNG file", "Name:");
                if (result.isBlank()) {
                    return;
                }
                try {
                    String folder = "Images" + CmcmResource.FS + "Models";
                    String path = String.valueOf(folder) + CmcmResource.FS;
                    String fileName = String.valueOf(result) + ".png";
                    new File(folder).mkdirs();
                    File newFile = new File(String.valueOf(path) + fileName);
                    if (!newFile.createNewFile()) {
                        DialogUtilities.showAlert("Error: File already exists!", "File creation failed. " + fileName + " already exists", Alert.AlertType.ERROR);
                        return;
                    }
                    WritableImage img = new WritableImage((int)(EditorController.this.model.getContentViewer().getCanvas().getScene().getWidth() - EditorController.this.eView.getPaletteWidth()), (int)EditorController.this.model.getContentViewer().getCanvas().getScene().getHeight());
                    Scene scene = EditorController.this.model.getContentViewer().getCanvas().getScene();
                    boolean wasShowingGrid = ((GridModel)EditorController.this.model.getContentViewer().getAdapter(GridModel.class)).isShowGrid();
                    ((GridModel)EditorController.this.model.getContentViewer().getAdapter(GridModel.class)).setShowGrid(false);
                    ((SelectionModel)EditorController.this.model.getContentViewer().getAdapter(SelectionModel.class)).clearSelection();
                    EditorController.this.eView.getChildren().remove((Object)EditorController.this.eView.getFunctionalityDisplay());
                    scene.snapshot(img);
                    EditorController.this.eView.setTop(EditorController.this.eView.getFunctionalityDisplay());
                    if (wasShowingGrid) {
                        ((GridModel)EditorController.this.model.getContentViewer().getAdapter(GridModel.class)).setShowGrid(true);
                    }
                    BufferedImage renImg = SwingFXUtils.fromFXImage((Image)img, null);
                    ImageIO.write((RenderedImage)renImg, "png", newFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void loginSuccessful() {
        this.model.setLoggedIn(true);
    }

    public void registerSuccessful() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogUtilities.showAlert("Success", "Register successful!\nYou are now being logged in.", Alert.AlertType.INFORMATION);
            }
        });
    }

    public void createProjectOverview(final List<Repository> repos) {
        repos.sort(Comparator.comparing(Repository::getName));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HashMap<TreeItem, Repository> itemToRepository = new HashMap<TreeItem, Repository>();
                HashMap<TreeItem, Pair> itemToVersion = new HashMap<TreeItem, Pair>();
                TreeItem invisibleRoot = new TreeItem((Object)"");
                TreeView repoTreeView = new TreeView(invisibleRoot);
                repoTreeView.setShowRoot(false);
                MenuItem showDetails = new MenuItem("Show Details");
                showDetails.setOnAction(a -> {
                    System.out.println(((TreeItem)repoTreeView.getSelectionModel().getSelectedItem()).toString());
                    System.out.println("Index: " + repoTreeView.getSelectionModel().getSelectedIndex());
                });
                showDetails.setDisable(true);
                repoTreeView.setContextMenu(new ContextMenu(new MenuItem[]{showDetails}));
                for (Repository repo : repos) {
                    TreeItem repoItem = new TreeItem((Object)repo.getName());
                    itemToRepository.put(repoItem, repo);
                    invisibleRoot.getChildren().add((Object)repoItem);
                    if (repo.getVersions() == null) continue;
                    for (Map.Entry<Integer, String> entry : repo.getVersions().entrySet()) {
                        TreeItem versionItem = new TreeItem((Object)(entry.getKey() + ". " + entry.getValue()));
                        itemToVersion.put(versionItem, new Pair((Object)repo, (Object)entry.getKey()));
                        repoItem.getChildren().add((Object)versionItem);
                    }
                }
                BooleanBinding noSelection = repoTreeView.getSelectionModel().selectedItemProperty().isNull();
                Button newModelButton = new Button("New Model");
                newModelButton.setOnAction(e -> EditorController.this.createNewModelDialog());
                Button deleteModelButton = new Button("Delete Model");
                deleteModelButton.setDisable(true);
                deleteModelButton.setOnAction(e -> {
                    TreeItem selectedItem = (TreeItem)repoTreeView.getSelectionModel().getSelectedItem();
                    if (itemToRepository.containsKey(selectedItem)) {
                        EditorController.this.networkService.requestDeleteModel((Repository)itemToRepository.get(selectedItem));
                        repoTreeView.getRoot().getChildren().remove((Object)selectedItem);
                    } else {
                        TreeItem repoToDelete = selectedItem.getParent();
                        EditorController.this.networkService.requestDeleteModel((Repository)itemToRepository.get(repoToDelete));
                        repoTreeView.getRoot().getChildren().remove((Object)repoToDelete);
                    }
                });
                Button openModelButton = new Button("Open Model");
                openModelButton.disableProperty().bind((ObservableValue)noSelection);
                openModelButton.setOnAction(e -> {
                    TreeItem selectedItem = (TreeItem)repoTreeView.getSelectionModel().getSelectedItem();
                    if (itemToRepository.containsKey(selectedItem)) {
                        System.out.println(itemToRepository.get(selectedItem));
                        EditorController.this.networkService.requestActiveDeltaOfModel((Repository)itemToRepository.get(selectedItem));
                    } else if (itemToVersion.containsKey(selectedItem)) {
                        Pair repoAndVersion = (Pair)itemToVersion.get(selectedItem);
                        System.out.println(repoAndVersion.getKey() + " version: " + repoAndVersion.getValue());
                        EditorController.this.networkService.requestVersionOfModel((Repository)repoAndVersion.getKey(), (Integer)repoAndVersion.getValue());
                    }
                });
                Button refreshButton = new Button("Refresh");
                refreshButton.setOnAction(e -> EditorController.this.networkService.requestModelList());
                ToolBar tb = new ToolBar(new Node[]{refreshButton, newModelButton, deleteModelButton});
                VBox vBox = new VBox(new Node[]{tb, repoTreeView, openModelButton});
                vBox.setPrefWidth(450.0);
                vBox.setPrefHeight(480.0);
                openModelButton.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
                EditorController.this.model.getEditorScene().setRoot((Parent)vBox);
                EditorController.this.model.getEditorScene().getWindow().sizeToScene();
            }
        });
    }

    private boolean createNewModelDialog() {
        Dialog newModelDialog = new Dialog();
        newModelDialog.setTitle("CMCM: New Model");
        newModelDialog.setHeaderText("Enter Name and Description: ");
        ButtonType confirmButtonType = new ButtonType("Confirm", ButtonBar.ButtonData.OK_DONE);
        newModelDialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{confirmButtonType, ButtonType.CANCEL});
        GridPane grid = new GridPane();
        grid.setHgap(4.0);
        grid.setVgap(4.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.add((Node)new Label("Name:"), 0, 0);
        grid.add((Node)new Label("Description:"), 0, 1);
        TextField nameField = new TextField();
        TextField descriptionField = new TextField();
        nameField.setPromptText("Name");
        descriptionField.setPromptText("Description");
        grid.add((Node)nameField, 1, 0);
        grid.add((Node)descriptionField, 1, 1);
        Node confirmButton = newModelDialog.getDialogPane().lookupButton(confirmButtonType);
        confirmButton.setDisable(true);
        nameField.textProperty().addListener((observable, oldValue, newValue) -> confirmButton.setDisable(newValue.length() < 3));
        newModelDialog.getDialogPane().setContent((Node)grid);
        Platform.runLater(() -> nameField.requestFocus());
        newModelDialog.setResultConverter(dialogButton -> {
            if (dialogButton == confirmButtonType) {
                return new Pair((Object)nameField.getText(), (Object)descriptionField.getText());
            }
            return null;
        });
        Optional result = newModelDialog.showAndWait();
        if (result.isPresent()) {
            result.ifPresent(nameAndDesc -> this.networkService.requestCreateNewModel((String)nameAndDesc.getKey(), (String)nameAndDesc.getValue()));
            return true;
        }
        return false;
    }

    public EditorView getView() {
        return this.eView;
    }

    public void giveScene(Scene scene) {
        this.model.setEditorScene(scene);
    }
}

