/*
 * Decompiled with CFR 0.152.
 */
package cmcm.application.network.shared.messages;

import cmcm.application.network.shared.messages.administration.request.SetRightMessage;
import cmcm.application.network.shared.messages.administration.request.SetRoleMessage;
import cmcm.application.network.shared.messages.administration.response.GetRightRoleMessage;
import cmcm.application.network.shared.messages.common.response.ErrorMessage;
import cmcm.application.network.shared.messages.common.response.StatusMessage;
import cmcm.application.network.shared.messages.repository.request.ApplyMicroVersionMessage;
import cmcm.application.network.shared.messages.repository.request.CreateMacroVersionMessage;
import cmcm.application.network.shared.messages.repository.request.CreateRepositoryMessage;
import cmcm.application.network.shared.messages.repository.request.DeleteRepositoryMessage;
import cmcm.application.network.shared.messages.repository.request.UpdateRepositoryMessage;
import cmcm.application.network.shared.messages.repository.response.GetRepositoryMessage;
import cmcm.application.network.shared.messages.user.request.CreateUserMessage;
import cmcm.application.network.shared.messages.user.request.DeleteUserMessage;
import cmcm.application.network.shared.messages.user.request.LoginMessage;
import cmcm.application.network.shared.messages.user.request.LogoutMessage;
import cmcm.application.network.shared.messages.user.request.UpdateUserMessage;
import cmcm.application.network.shared.messages.user.response.GetUserMessage;
import java.util.HashMap;
import java.util.Map;

public enum MessageType {
    CreateUser(0, CreateUserMessage.class),
    GetUser(1, cmcm.application.network.shared.messages.user.request.GetUserMessage.class),
    UpdateUser(2, UpdateUserMessage.class),
    DeleteUser(3, DeleteUserMessage.class),
    Login(4, LoginMessage.class),
    Logout(5, LogoutMessage.class),
    GetUserResp(-1, GetUserMessage.class),
    CreateRepository(10, CreateRepositoryMessage.class),
    GetRepository(11, cmcm.application.network.shared.messages.repository.request.GetRepositoryMessage.class),
    UpdateRepository(12, UpdateRepositoryMessage.class),
    DeleteRepository(13, DeleteRepositoryMessage.class),
    ApplyMicroVersion(14, ApplyMicroVersionMessage.class),
    CreateMacroVersion(15, CreateMacroVersionMessage.class),
    GetRepositoryResp(-11, GetRepositoryMessage.class),
    ApplyMicroVersionResp(-14, cmcm.application.network.shared.messages.repository.response.ApplyMicroVersionMessage.class),
    SetRight(20, SetRightMessage.class),
    SetRole(21, SetRoleMessage.class),
    GetRightRole(22, cmcm.application.network.shared.messages.administration.request.GetRightRoleMessage.class),
    GetRightRoleResp(-22, GetRightRoleMessage.class),
    Status(100, StatusMessage.class),
    Error(101, ErrorMessage.class);

    private int value;
    private Class messageClass;
    private static Map<Integer, MessageType> lookup;

    static {
        lookup = new HashMap<Integer, MessageType>();
        MessageType[] messageTypeArray = MessageType.values();
        int n = messageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageType type = messageTypeArray[n2];
            lookup.put(type.value, type);
            ++n2;
        }
    }

    private MessageType(int value, Class messageClass) {
        this.value = value;
        this.messageClass = messageClass;
    }

    public Class getMessageClass() {
        return this.messageClass;
    }

    public int getValue() {
        return this.value;
    }

    public static MessageType fromValue(int value) {
        return lookup.get(value);
    }
}

