/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_smn extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "u\u0111\u0111\u00e2ivem\u00e1\u00e1nu",
               "kuov\u00e2m\u00e1\u00e1nu",
               "njuh\u010d\u00e2m\u00e1\u00e1nu",
               "cu\u00e1\u014buim\u00e1\u00e1nu",
               "vyesim\u00e1\u00e1nu",
               "kesim\u00e1\u00e1nu",
               "syeinim\u00e1\u00e1nu",
               "porgem\u00e1\u00e1nu",
               "\u010doh\u010d\u00e2m\u00e1\u00e1nu",
               "roovv\u00e2dm\u00e1\u00e1nu",
               "skamm\u00e2m\u00e1\u00e1nu",
               "juovl\u00e2m\u00e1\u00e1nu",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "u\u0111iv",
               "kuov\u00e2",
               "njuh\u010d\u00e2",
               "cu\u00e1\u014bui",
               "vyesi",
               "kesi",
               "syeini",
               "porge",
               "\u010doh\u010d\u00e2",
               "roovv\u00e2d",
               "skamm\u00e2",
               "juovl\u00e2",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "U",
               "K",
               "NJ",
               "C",
               "V",
               "K",
               "S",
               "P",
               "\u010c",
               "R",
               "S",
               "J",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "pasepeeivi",
               "vuossaarg\u00e2",
               "majebaarg\u00e2",
               "koskoho",
               "tuor\u00e2stuv",
               "v\u00e1stuppeeivi",
               "l\u00e1vurduv",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "pas",
               "vuo",
               "maj",
               "kos",
               "tuo",
               "v\u00e1s",
               "l\u00e1v",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "p",
               "V",
               "M",
               "K",
               "T",
               "V",
               "L",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1. ni\u00e4lj\u00e1d\u00e2s",
               "2. ni\u00e4lj\u00e1d\u00e2s",
               "3. ni\u00e4lj\u00e1d\u00e2s",
               "4. ni\u00e4lj\u00e1d\u00e2s",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "1. ni\u00e4lj.",
               "2. ni\u00e4lj.",
               "3. ni\u00e4lj.",
               "4. ni\u00e4lj.",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "ip.",
               "ep.",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] metaValue_Eras = new String[] {
               "oKr.",
               "mKr.",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "H.mm.ss zzzz",
               "H.mm.ss z",
               "H.mm.ss",
               "H.mm",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "cccc MMMM d. y G",
               "MMMM d. y G",
               "d.M.y G",
               "d.M.y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE MMMM d. y GGGG",
               "MMMM d. y GGGG",
               "d.M.y GGGG",
               "d.M.y G",
            };
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "roc.DayNames", metaValue_DayNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "long.Eras",
                new String[] {
                    "Ovdil Kristus \u0161odd\u00e2m",
                    "ma\u014ba Kristus \u0161odd\u00e2m",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} 'tme' {0}",
                    "{1} 'tme' {0}",
                    "{1} 'tme' {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    "\u00a0",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "epiloho",
                    "",
                    "",
                }
            },
            { "java.time.DatePatterns",
                new String[] {
                    "cccc, MMMM d. y",
                    "MMMM d. y",
                    "MMM d. y",
                    "d.M.y",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_DayNames },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "DatePatterns",
                new String[] {
                    "EEEE, MMMM d. y",
                    "MMMM d. y",
                    "MMM d. y",
                    "d.M.y",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "pasepeivi",
                    "vuossarg\u00e2",
                    "majebarg\u00e2",
                    "koskokko",
                    "tuor\u00e2st\u00e2h",
                    "v\u00e1stuppeivi",
                    "l\u00e1vurd\u00e2h",
                }
            },
            { "PluralRules", "one:n = 1;two:n = 2" },
            { "japanese.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0\u00a0%",
                    "#,##0.00\u00a0\u00a4",
                }
            },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' 'tuhh\u00e1\u00e1t two:0' 'tuhh\u00e1\u00e1t other:0' 'tuhh\u00e1\u00e1t}",
                    "{one:00' 'tuhh\u00e1\u00e1t two:00' 'tuhh\u00e1\u00e1t other:00' 'tuhh\u00e1\u00e1t}",
                    "{one:000' 'tuhh\u00e1\u00e1t two:000' 'tuhh\u00e1\u00e1t other:000' 'tuhh\u00e1\u00e1t}",
                    "{one:0' 'miljovn two:0' 'miljovn other:0' 'miljovn}",
                    "{one:00' 'miljovn two:00' 'miljovn other:00' 'miljovn}",
                    "{one:000' 'miljovn two:000' 'miljovn other:000' 'miljovn}",
                    "{one:0' 'miljard two:0' 'miljard other:0' 'miljard}",
                    "{one:00' 'miljard two:00' 'miljard other:00' 'miljard}",
                    "{one:000' 'miljard two:000' 'miljard other:000' 'miljard}",
                    "{one:0' 'biljovn two:0' 'biljovn other:0' 'biljovn}",
                    "{one:00' 'biljovn two:00' 'biljovn other:00' 'biljovn}",
                    "{one:000' 'biljovn two:000' 'biljovn other:000' 'biljovn}",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
        };
        return data;
    }
}
